<?php

namespace IZON\Admin\MVC\Exceptions\Handlers;

use IZON\Admin\MVC\Exceptions\AdminPageNotFoundException;
use IZON\Logs\LogLevel;
use IZON\MVC\Exceptions\Handlers\IAppExceptionHandler;
use IZON\MVC\HttpRequest;
use Throwable;

/**
 * Handles if page is not found
 */
class AdminPageNotFoundExceptionHandler implements IAppExceptionHandler {
    
    protected $htmlToShow;
    
    function __construct($htmlToShow) {
        $this->htmlToShow = $htmlToShow;
    }
    
    public function getLogLevel() {
        return LogLevel::WARN;
    }

    public function handleException(Throwable $exception, ?HttpRequest $request) {
        require $this->htmlToShow;
    }

    public function isFor(Throwable $exception) {
        return $exception instanceof AdminPageNotFoundException;
    }
}
