<?php

namespace IZON\Admin\DB;

use IZON\DB\QueryHelpers;
use IZON\DB\QueryFactory;

use IZON\Admin\Domain\AdminUserRole;
use IZON\Admin\Domain\AdminRoleModule;

/**
 * 
 */
class AdminRoleQueryFactory implements QueryFactory {
    
    /**
     * Vraci vsechny role pro uzivatele
     * @param QueryHelpers
     */
    public function findUserRoles_1(QueryHelpers $queryHelpers) {
        return "select ". $queryHelpers->getClassProperties("r") 
                ." from ". $queryHelpers->getTableName("r")
                ." join ". $queryHelpers->getClassTableName(AdminUserRole::class, "ur") 
                        ." on ". $queryHelpers->getCoumnName("id", "r") ." = ". $queryHelpers->getClassCoumnName(AdminUserRole::class, "fkAdminRoleId", "ur")
                ." where ". $queryHelpers->getClassCoumnName(AdminUserRole::class, "fkAdminUserId", "ur") ." = :arg0"
                ." limit :maxResults offset :firstResult";
    }
    
    /**
     * Vraci vsechny role pro uzivatele
     * @param QueryHelpers
     */
    public function findModuleRoles_1(QueryHelpers $queryHelpers) {
        return "select ". $queryHelpers->getClassProperties("r") 
                ." from ". $queryHelpers->getTableName("r")
                ." join ". $queryHelpers->getClassTableName(AdminRoleModule::class, "rm") 
                        ." on ". $queryHelpers->getCoumnName("id", "r") ." = ". $queryHelpers->getClassCoumnName(AdminUserRole::class, "fkAdminRoleId", "rm")
                ." where ". $queryHelpers->getClassCoumnName(AdminRoleModule::class, "fkAdminModuleId", "rm") ." = :arg0"
                ." limit :maxResults offset :firstResult";
    }
    
}
