<?php

use IZON\Admin\Config;
use IZON\Admin\Dao\AdminModuleDao;
use IZON\Admin\Dao\AdminModuleSettingDao;
use IZON\Admin\Dao\AdminRoleDao;
use IZON\Admin\Dao\AdminRoleModuleDao;
use IZON\Admin\Dao\AdminUserDao;
use IZON\Admin\Dao\AdminUserRoleDao;
use IZON\Admin\Services\Impl\AdminServiceImpl;
use IZON\Admin\Services\Impl\SessionServiceImpl;
use IZON\Admin\Web\Controllers\DashboardController;
use IZON\Admin\Web\Controllers\LoginController;
use IZON\Admin\Web\Controllers\LogoutController;
use IZON\Admin\Web\Controllers\NotificationsController;
use IZON\Admin\Web\Controllers\SwitchCountryController;
use IZON\Admin\Web\Controllers\SwitchInterfaceLocaleController;
use IZON\Admin\Web\Interceptors\HandleLoggedUserInterfaceLocaleInterceptor;
use IZON\Admin\Web\Interceptors\LoadAdminVersionInterceptor;
use IZON\Admin\Web\Interceptors\LoadMaxFileSizeInterceprtor;
use IZON\Admin\Web\Interceptors\LoggedUserCheckInterceptor;
use IZON\Admin\Web\Interceptors\LoggedUserInterceptor;
use IZON\Admin\Web\Interceptors\LoggedUserModulesInterceptor;
use IZON\Admin\Web\Interceptors\SupportedCountriesInterceptor;
use IZON\DB\DaoFactoryBean;
use IZON\DBLocale\Dao\CountryDao;
use IZON\DBLocale\Dao\CurrencyDao;
use IZON\DBLocale\Dao\LanguageDao;
use IZON\DBLocale\Dao\LocaleDao;
use function IZON\DI\factoryBean;
use function IZON\DI\get;
use function IZON\DI\object;

return [
    'izon.admin.dao.adminModuleDao' => factoryBean(DaoFactoryBean::class)
                                                    ->constructor(get('db.connection'), AdminModuleDao::class),
    'izon.admin.dao.adminUserDao' => factoryBean(DaoFactoryBean::class)
                                                    ->constructor(get('db.connection'), AdminUserDao::class),
    'izon.admin.dao.adminRoleDao' => factoryBean(DaoFactoryBean::class)
                                                    ->constructor(get('db.connection'), AdminRoleDao::class),
    'izon.admin.dao.adminUserRoleDao' => factoryBean(DaoFactoryBean::class)
                                                    ->constructor(get('db.connection'), AdminUserRoleDao::class),
    'izon.admin.dao.adminModuleSettingDao' => factoryBean(DaoFactoryBean::class)
                                                    ->constructor(get('db.connection'), AdminModuleSettingDao::class),
    /// inicializace pod tridami rozhrani aby fungoval autoresolve
    AdminModuleDao::class => factoryBean(DaoFactoryBean::class)
                                                    ->constructor(get('db.connection'), AdminModuleDao::class),
    AdminUserDao::class => factoryBean(DaoFactoryBean::class)
                                                    ->constructor(get('db.connection'), AdminUserDao::class),
    AdminRoleDao::class => factoryBean(DaoFactoryBean::class)
                                                    ->constructor(get('db.connection'), AdminRoleDao::class),
    AdminUserRoleDao::class => factoryBean(DaoFactoryBean::class)
                                                    ->constructor(get('db.connection'), AdminUserRoleDao::class),
    AdminModuleSettingDao::class => factoryBean(DaoFactoryBean::class)
                                                    ->constructor(get('db.connection'), AdminModuleSettingDao::class),
    AdminRoleModuleDao::class => factoryBean(DaoFactoryBean::class)
                                                    ->constructor(get('db.connection'), AdminRoleModuleDao::class),
    
    
    'izon.admin.dao.CountryDao' => factoryBean(DaoFactoryBean::class)
                                                    ->constructor(get('db.connection'), CountryDao::class),
    
    'izon.admin.dao.localeDao' => factoryBean(DaoFactoryBean::class)
                                                    ->constructor(get('db.connection'), LocaleDao::class),
    
    'izon.admin.dao.languageDao' => factoryBean(DaoFactoryBean::class)
                                                    ->constructor(get('db.connection'), LanguageDao::class),
    
    'izon.admin.dao.currencyDao' => factoryBean(DaoFactoryBean::class)
                                                    ->constructor(get('db.connection'), CurrencyDao::class),
    
    Config::ADMIN_SERVICE_IDENTIFIER => object(AdminServiceImpl::class)
                                                    ->constructor(get('izon.admin.dao.adminModuleDao'),
                                                                    get('izon.admin.dao.adminModuleSettingDao'),
                                                                    get('izon.admin.dao.localeDao'),
                                                                    get('izon.admin.dao.CountryDao'),
                                                                    get('izon.admin.dao.languageDao'))
                                                    ->method("setSupportedInterfaceLocaleIdes", get('locale.admin.supportedAdminInterfaceLocaleIdes')),
    
    // TODO: umoznit jeho prepsani v configu
    'izon.admin.service.adminSessionService' => object(SessionServiceImpl::class)
                                                    ->constructor(
                                                                get(Config::ADMIN_SERVICE_IDENTIFIER),
                                                                get(Config::CONFIG_DIR_IDENTIFIER),
                                                                get("admin.modulesActions"),
                                                                IZON\Admin\DI\modulesDirs(),
                                                                get('locale.dir'),
                                                                get('locale.tempDir'),
                                                                get('izon.admin.dao.adminUserDao'),
                                                                get('izon.admin.dao.adminRoleDao'),
                                                                get('izon.admin.dao.adminModuleDao'),
                                                                get('izon.admin.dao.CountryDao'),
                                                                get('izon.admin.dao.localeDao'),
                                                                get('izon.admin.dao.languageDao'),
                                                                get('izon.admin.dao.currencyDao'))
                                                    ->method("setRoleSupportedCountries", get('admin.roleSupportedCountries')),
    
    //// controllery pro admin
    // controller pro prihlaseni a odhlaseni
    Config::LOGIN_CONTROLLER_IDENTIFIER => object(LoginController::class)
                                                    ->constructor(get('izon.admin.service.adminSessionService'),
                                                                 Config::DASHBOARD_CONTROLLER_IDENTIFIER),
    
    // controller pro uvodku adminu
    Config::DASHBOARD_CONTROLLER_IDENTIFIER => object(DashboardController::class)
                                                    ->constructor(get(Config::ADMIN_SERVICE_IDENTIFIER)),
    
    // controller pro odhlaseni z admina
    Config::LOGOUT_CONTROLLER_IDENTIFIER => object(LogoutController::class)
                                                    ->constructor(get('izon.admin.service.adminSessionService'),
                                                                Config::LOGIN_CONTROLLER_IDENTIFIER),
    
    // controller pro zmenu jazyka
    Config::SWITCH_COUNTRY_CONTROLLER_IDENTIFIER => object(SwitchCountryController::class)
                                                    ->constructor(get('izon.admin.service.adminSessionService'),
                                                                 Config::DASHBOARD_CONTROLLER_IDENTIFIER),
    
    // controller pro zmenu jazyka
    Config::SWITCH_INTERFACE_LOCALE_CONTROLLER_IDENTIFIER => object(SwitchInterfaceLocaleController::class)
                                                    ->constructor(get('izon.admin.service.adminSessionService'),
                                                                 Config::DASHBOARD_CONTROLLER_IDENTIFIER),
    
    // controller pro spravu notifikaci
    Config::NOTIFICATIONS_CONTROLLER_IDENTIFIER => object(NotificationsController::class)
                                                    ->constructor(get(Config::ADMIN_SERVICE_IDENTIFIER)),
    
    
    //// interceptory pro admin
    // interceptor pro kontrolu prihlaseneho uzivatele
    Config::LOGGED_USER_CHECK_INTERCEPTOR_IDENTIFIER => object(LoggedUserCheckInterceptor::class)
                                                    ->constructor(get('izon.admin.service.adminSessionService')),
    
    Config::ADMIN_HEADER_LINK_INTERCEPTOR_IDENTIFIER => object(IZON\Admin\Web\Interceptors\HeaderLinkInterceptor::class)
                                                    ->constructor(
                                                            get('izon.admin.headerLink.controllerUid'),
                                                            get('izon.admin.headerLink.params')
                                                            ),
    
    // interceptor pro nacteni prihlaseneho uzivatele
    Config::HANDLE_LOGGED_USER_INTERFACE_LOCALE_INTERCEPTOR => object(HandleLoggedUserInterfaceLocaleInterceptor::class)
                                                    ->constructor(get('izon.admin.service.adminSessionService')),
    
    // interceptor pro nacteni prihlaseneho uzivatele
    Config::LOGGED_USER_INTERCEPTOR_IDENTIFIER => object(LoggedUserInterceptor::class)
                                                    ->constructor(get('izon.admin.service.adminSessionService')),
    
    // interceptor pro nacteni akci admina
    Config::MODULES_ACTIONS_INTERCEPTOR_IDENTIFIER => object(LoggedUserModulesInterceptor::class)
                                                    ->constructor(get('izon.admin.service.adminSessionService'),
                                                                    get('admin.modulesActions')),
    
    // interceptor pro nacteni akci admina
    Config::MODULES_SUPPORTED_COUNTRIES_INTERCEPTOR_IDENTIFIER => object(SupportedCountriesInterceptor::class)
                                                    ->constructor(get('izon.admin.service.adminSessionService')),
    
    // nacte verzi admina
    Config::ADMIN_VERSION_INTERCEPTOR_IDENTIFIER => object(LoadAdminVersionInterceptor::class)
                                                    ->constructor(get(Config::ADMIN_SERVICE_IDENTIFIER)),
    
    //nacte max file size
    Config::ADMIN_MAX_FILE_SIZE_INTERCEPTOR_IDENTIFIER => object(LoadMaxFileSizeInterceprtor::class),
                                                    
];