<?php
namespace IZON\Admin\Services\Impl;

use IZON\DB\Dao;
use \IZON\DB\Paginator\PaginatorConfig;

use IZON\Admin\Services\SimpleAdminService;

/**
 * Jesnoducy servis pro vytvoreni editace jedne tridy
 * 
 * umoznuje:
 * - natahnout stranky se seznamem polozek
 * - natahnout jednu polozku
 * - ulozit novou polozku
 * - updatovat existujici polozku
 */
class SimpleAdminServiceImpl extends \IZON\Admin\Services\AbstractBaseService implements SimpleAdminService {    

    /**
     * dao to access edited object
     * @var Dao 
     */
    protected $objectDao;
    
    
    public function __construct(Dao $objectDao) {
        $this->objectDao = $objectDao;
        $this->dao       = $objectDao;
    }
    
    /**
     * vrati defaultni strankovac
     */
    public function getPaginatorConfig($name = PaginatorConfig::DEFAULT_PAGINATOR_NAME,
                                $definedFields = [],
                                $maxPageSize = SimpleAdminService::DEFAULT_MAX_PAGE_SIZE) {
        $pagetConfig = new PaginatorConfig($name, $definedFields, $maxPageSize);
        return $pagetConfig;
    }
    
    /**
     * vrati aktivni moduly
     */
    public function getPage(PaginatorConfig $config) {
        return $this->objectDao->paginate($config);
    }
    
    /**
     * vrati objekt s danym id nebo vyhodi nenalezeno vyjimky
     * TODO: vytvorit nejakou takovou vijimku v db vrstve
     * @param integer $id
     */
    public function get($id) {
        return $this->objectDao->load($id);
    }
    /**
     * Return array of all objects from mapped table
     * @param array $where - array, where key is object property name
     * @param array $orderBy - array, where key is object property name and value is bool - true for ASC, false for DESC
     * @return array 
     */
    public function getAll($where = [], $orderBy = []) {
      return $this->objectDao->find($where, $orderBy)->listResult();
    }
    
    public function update($obj) {
        $this->objectDao->update($obj);
    }
    
    public function save($obj) {
        return $this->objectDao->save($obj);
    }

    public function delete($id) {
       $this->objectDao->beginTransaction();
       $this->objectDao->delete($id); 
       $this->objectDao->commit();  
    }
    
    public function beginTransaction() {
      $this->dao->beginTransaction();
    }

    public function commitTransaction() {
      $this->dao->commit();
    }

    public function rollBackTransaction() {
      $this->dao->rollBack();
    }
}