<!-- Sidebar -->
<?php
    $activeModule = \PHPView\getParameter(IZON\Admin\MVC\ModuleInfo::MODULE_INFO_INDENTIFIER);
    /* @var $loggedUserModules \IZON\Admin\Presentation\Domain\AdminModuleInfo[] */
    $loggedUserModules = \PHPView\getParameter("loggedUserModules");
?>
<nav class="nav">
    <ul>
        <li>
            <a href="<?= \PHPView\getControllerURL("izon.admin.controller.dashboardController") ?>" class="nav__link icon--desktop<?= $activeModule == NULL ? " active" : "" ?>"><?= __('Nástěnka') ?></a>
        </li>
        <?php
            foreach($loggedUserModules as $moduleId => $moduleInfo) {
                $defaultAction = $moduleInfo->getDefaultAction();
                
                $moduleURL = AdminPHPView\getModuleActionURL($defaultAction->getControllerIdentifier(),
                                                                $defaultAction->getMethodName(),
                                                                $defaultAction->getParameters(),
                                                                $moduleInfo->getIdentifier());
                $icon = $moduleInfo->getIcon();
                if( $icon == NULL) {
                    $icon = "list";
                }
            ?>
                <li<?= ($icon=='superuser'?' class="nav__item--superuser"':'') ?>>
                    <a href="<?= $moduleURL ?>" class="nav__link<?= ($moduleInfo->isCurrentModule() ? " active" : "") ?>"><?= $moduleInfo->getModuleName() ?>
                        <i class="fas fa-<?= $icon?>"></i>
                    </a>
                    <?php
                    if( $moduleInfo->isCurrentModule() ) {
                        $menuActions = $moduleInfo->getModuleMenuActions();
                        echo '<ul class="nav__subnav">';
                        foreach($menuActions as $menuAction) {
                            $moduleURL = AdminPHPView\getModuleActionURL($menuAction->getControllerIdentifier(),
                                                                        $menuAction->getMethodName(),
                                                                        $menuAction->getParameters(),
                                                                        $moduleInfo->getIdentifier());
                            ?>
                            <li>
                                
                                    <?php
                                        if($menuAction->isCurrentAction() || $menuAction->isParentAction()) {
                                            echo '<a href="'.$moduleURL .'" class="nav__link active">'.
                                                    '<i class="fas fa-angle-right"></i>'.
                                                    $menuAction->getName().
                                                '</a>';
                                        }else {
                                            echo '<a href="'.$moduleURL .'" class="nav__link">'.
                                                    $menuAction->getName().
                                                '</a>';

                                        }
                                    ?>
                                </a>
                            </li>
                            <?php
                        }
                        echo '</ul>';
                    }
                    ?>
                </li>
            <?php
            }
        ?>
    </ul>
</nav>
<!-- /sidebar -->