<?php

namespace IZON\Admin\Presentation\Domain;

use Exception;

use IZON\Admin\Domain\AdminModule;

/**
 * information about module, can be used for example in menu
 */
class AdminModuleInfo {
    
    /**
     * @var AdminModule
     */
    protected $adminModule;

    /**
     * @var string 
     */
    protected $moduleName;
    
    /**
     * @var AdminModuleActionInfo[] hash of all registred module actions 
     */
    protected $adminModuleActionInfos;

    /**
     * @var string 
     */
    protected $defaultActionIdentifier;
    
    /**
     * @var string[] actions 
     */
    protected $adminModuleMenuActionIdentifiers;
    
    /**
     * @var integer locale to show locale depandent data
     */
    protected $localeId;

    /**
     * @var boolean true if this is mudule its action is currently selected
     */
    protected $currentModule = false;
    

/// genrovany konstruktor
    function __construct(AdminModule $adminModule, array $adminModuleActionInfos, $defaultActionIdentifier, $adminModuleMenuActionIdentifiers, $localeId) {
        $this->adminModule = $adminModule;
        $this->adminModuleActionInfos = $adminModuleActionInfos;
        $this->defaultActionIdentifier = $defaultActionIdentifier;
        $this->adminModuleMenuActionIdentifiers = $adminModuleMenuActionIdentifiers;
        $this->localeId = $localeId;
    }

    /**
     * all actions from menu
     * @return AdminModuleActionInfo[]
     * @throws Exception
     */
    function getModuleMenuActions() {
        $menuActions = [];
        foreach($this->adminModuleMenuActionIdentifiers as $actionIdentifier) {
            if( !array_key_exists($actionIdentifier, $this->adminModuleActionInfos) ) {
                throw new Exception("Module ". $this->adminModule->getIdentifier() ." doesn't have action ". $actionIdentifier);
            }
            $menuActions[] = $this->adminModuleActionInfos[$actionIdentifier];
        }
        return $menuActions;
    }
    
    function isCurrentModule() {
        return $this->currentModule;
    }

    function setCurrentModule($currentModule) {
        $this->currentModule = $currentModule;
    }
    
    function getIdentifier() {
        return $this->adminModule->getIdentifier();
    }
    
    function getIcon() {
        return $this->adminModule->getIcon();
    }
    
    function getDefaultAction() {
        if( !array_key_exists($this->defaultActionIdentifier, $this->adminModuleActionInfos) ) {
            throw new Exception("Module ". $this->adminModule->getIdentifier() ." default action ". $this->defaultActionIdentifier ." doesn't exist");
        }
        return $this->adminModuleActionInfos[$this->defaultActionIdentifier];
    }


/// generated getters no need for setters for this properties
    function getAdminModule() {
        return $this->adminModule;
    }

    function getAdminModuleActionInfos() {
        return $this->adminModuleActionInfos;
    }

    function getDefaultActionIdentifier() {
        return $this->defaultActionIdentifier;
    }

    function getAdminModuleMenuActionIdentifiers() {
        return $this->adminModuleMenuActionIdentifiers;
    }
    
/// generated getters and setters
    function getLocaleId() {
        return $this->localeId;
    }
    
    function setLocaleId($localeId) {
        $this->localeId = $localeId;
    }
    
    function getModuleName() {
        return $this->moduleName;
    }

    function setModuleName($moduleName) {
        $this->moduleName = $moduleName;
    }
}
