<?php

/**
 * funkce pro zjednoduseni vypisu formularovych poli
 */

namespace IZON\Admin\Forms;


/**
 * Vrati html kod formularoveho prvku
 * 
 * @param \IZON\Forms\Form $form
 * @param string $fieldName nazev prvku
 * @param array $params pole s parametry<br>
 * $params['template'] = jaky se ma pouzit template - defaultne "default"<br>
 * $params['raw'] = true - pokud je treba vratit jen input bez labelu, defaultne false <br>
 * $params['noCaption'] = true - pokud je treba vratit input obaleny labelem ale bez textu, defaultne false <br>
 * $params['caption'] - parametry pro popisek pole - struktura obdobna jako u definice tempalte, jen v polich <br>
 * $params['wrapper'] - parametry pro wrapper pole - struktura obdobna jako u definice tempalte, jen v polich<br>
 * $params['field'] - parametry formularove pole - struktura obdobna jako u definice tempalte, jen v polich<br>
 * $params['error'] - parametry formularove pole - struktura obdobna jako u definice tempalte, jen v polich<br>
 * @return string
 */
function getAdminField(\IZON\Forms\Form $form, $fieldName, $params = array()) {
  
  if(!array_key_exists('template', $params) || empty($params['template'])) {
    $params['template'] = 'default';
  }
  return \IZON\Forms\FormFieldTemplate::getFiled($params['template'], \IZON\Forms\FormFieldTemplate::TYPE_BACKEND, $form->getField($fieldName), $params);
}

/**
 * Only wrapper for getAdminField<br>
 * 
 * @param \IZON\Forms\Form $form
 * @param string $fieldName
 * @param array $params
 * @return string
 */
function getField(\IZON\Forms\Form $form, $fieldName, $params = array()) {
  return getAdminField($form, $fieldName, $params);
}
