<?php

namespace IZON\Admin\DI\Definition\Resolver;

use RuntimeException;

use DI\Definition\Definition;
use DI\Definition\Resolver\DefinitionResolver;

use IZON\Admin\DI\Definition\ModuleConfigDefinition;
use IZON\Admin\DI\Definition\ModuleConfigsDefinition;
use IZON\Admin\DI\Definition\Resolver\ModuleConfigsResolver;



/**
 * Container pro pristup k predkum
 * 
 * upravena trida z \DI\Definition\Resolver\DefinitionResolver
 * 
 */
class ResolverDispatcher extends \IZON\DI\Definition\Resolver\ResolverDispatcher implements DefinitionResolver {
    
    /**
     * @var ModuleConfigResolver 
     */
    protected $moduleConfigResolver;
    
    /**
     * @var ModuleConfigsResolver 
     */
    protected $moduleConfigsResolver;

    
    /**
     * Returns a resolver capable of handling the given definition.
     *
     * @param Definition $definition
     *
     * @throws RuntimeException No definition resolver was found for this type of definition.
     * @return DefinitionResolver
     */
    protected function getDefinitionResolver(Definition $definition) {
        switch(true) {
            case $definition instanceof ModuleConfigDefinition:
                if(!$this->moduleConfigResolver) {
                    $this->moduleConfigResolver = new ModuleConfigResolver($this->container);
                }
                return $this->moduleConfigResolver;
            case $definition instanceof ModuleConfigsDefinition:
                if(!$this->moduleConfigsResolver) {
                    $this->moduleConfigsResolver = new ModuleConfigsResolver($this->container);
                }
                return $this->moduleConfigsResolver;
            default:
                return parent::getDefinitionResolver($definition);
        }
    }

}
