<?php

namespace IZON\Admin\MVC\Views;

use Exception;

use IZON\Logs\Logger;

use IZON\MVC\Views\PHPView;

/**
 * trida renderujici view, resici cachovani rendrovani view, skladajici view 
 * z jednotlivych casti, ...
 * jednotliva view jsou ulozena v adresarich
 * pri devel modu naincluduje nekde dole ve strance misto na debug informace
 *
 * @author David Dryml <dryml@izon.cz>
 * @copyright Copyright 2009, HI Software s.r.o.
 *
 * @version v1.0 rc
 *
 * @package MVC
 */
class AdminPHPView extends PHPView {

    /**
     * suffix of view file
     */
    const VIEW_SUFFIX = ".tmpl.php";

    /**
     * suffix of library files
     */
    const LIBRARY_FILE_SUFFIX = ".php";
    
    /**
     *
     * @var string cesta ke view, ktere se ma pouzit 
     */
    protected $viewPath;

    /**
     * @var string[] urls of styles to be autoloaded to admin
     */
    protected $stylesAutoloadURLs = [];

    /**
     * @var string[] urls of scripts to be autoloaded to admin
     */
    protected $scriptsAutoloadURLs = [];
    

    /**
     * @var Logger|null logger pro tridu
     */
    protected $log;
    
    /**
     * vytvari view podle zadaneho jmena a predava mu parametry
     */
    function __construct($viewPath) {
        parent::__construct($viewPath);
        
         // logovani
        $this->log = Logger::getLogger(__CLASS__);
    }

    /**
     * provede vykresleni celeho view
     */
    function render() {
        // load libraries
        foreach($this->librariesDirs as $librariesDir) {
            if( file_exists($librariesDir) && is_dir($librariesDir) ) { // search only existing folders
                foreach(scandir($librariesDir) as $file) {
                    if( \IZON\String\endsWith($file, self::LIBRARY_FILE_SUFFIX) ) {
                        require_once $librariesDir ."/". $file;
                    }
                }
            }
        }
        
        // render view
        require_once $this->viewPath;
    }
    
    
/// generated getters and setters
    function getStylesAutoloadURLs() {
        return $this->stylesAutoloadURLs;
    }

    function getScriptsAutoloadURLs() {
        return $this->scriptsAutoloadURLs;
    }

    function setStylesAutoloadURLs($stylesAutoloadURLs) {
        $this->stylesAutoloadURLs = $stylesAutoloadURLs;
    }

    function setScriptsAutoloadURLs($scriptsAutoloadURLs) {
        $this->scriptsAutoloadURLs = $scriptsAutoloadURLs;
    }
}