<?php

namespace IZON\Admin\MVC\Exceptions\Handlers;

use Exception;

use \IZON\Logs\LogLevel;

use \IZON\MVC\Exceptions\Handlers\AppExceptionHandler;

use \IZON\Admin\MVC\Exceptions\AdminPageNotFoundException;

/**
 * Handles if page is not found
 */
class AdminPageNotFoundExceptionHandler implements AppExceptionHandler {
    
    protected $htmlToShow;
    
    function __construct($htmlToShow) {
        $this->htmlToShow = $htmlToShow;
    }
    
    public function getLogLevel() {
        return LogLevel::WARN;
    }

    public function handleException(Exception $exception) {
        require $this->htmlToShow;
    }

    public function isFor(Exception $exception) {
        return $exception instanceof AdminPageNotFoundException;
    }
}
