<?php

namespace IZON\Admin\Web\Interceptors;

use IZON\Admin\Services\LoggedAdminUserSessionServiceInterface;
use IZON\MVC\HttpRequest;
use IZON\MVC\Interceptors\Interceptor;
use IZON\MVC\ModelAndView;

/**
 * zpristupni prihlaseneho uzivatele pro view
 * @deprecated is not used in admin 4.4 lang_forms used instead
 */
class SupportedCountriesInterceptor implements Interceptor
{
    protected LoggedAdminUserSessionServiceInterface $sessionService;

    /**
     * pod jakym jemnem se ma zpristupnit ve view
     * @var string
     */
    protected string $supportedCountriesModelName = "adminSupportedCountries";


    public function __construct(LoggedAdminUserSessionServiceInterface $sessionService)
    {
        $this->sessionService = $sessionService;
    }

    public function afterCompletion(HttpRequest $request, $exception)
    {
    }

    public function postHandle(HttpRequest $request, ModelAndView $model)
    {
        $countries = $this->sessionService->getUserCountries();
        $model->putParameter($this->supportedCountriesModelName, $countries);
        return $model;
    }

    public function preHandle(HttpRequest $request)
    {
        return null;
    }
}
