<?php

namespace IZON\Admin\Web\Interceptors;

use IZON\Admin\MVC\ModuleInfo;
use IZON\Admin\Services\LoggedAdminUserSessionServiceInterface;
use IZON\Logs\Logger;
use IZON\MVC\HttpRequest;
use IZON\MVC\Interceptors\Interceptor;
use IZON\MVC\ModelAndView;

/**
 * returns all modules accessible to currently logged user
 */
class LoggedUserModulesInterceptor implements Interceptor
{
    protected LoggedAdminUserSessionServiceInterface $sessionService;

    protected array $modulesActions;

    /**
     * logger pro tridu
     * @var Logger
     */
    protected $log;


    public function __construct(
        LoggedAdminUserSessionServiceInterface $sessionService,
        array $modulesActions
    ) {
        $this->sessionService = $sessionService;
        $this->modulesActions = $modulesActions;

        // logovani
        $this->log = Logger::getLogger(__CLASS__);
    }

    public function afterCompletion(HttpRequest $request, $exception)
    {
    }

    public function preHandle(HttpRequest $request)
    {
        return null;
    }

    public function postHandle(HttpRequest $request, ModelAndView $model)
    {
        // all user accessable modules
        $modules = $this->sessionService->getLoggedUserModules();

        /// find and set current acition name and identifier
        $moduleInfo = null;
        if ($request->hasParameter(ModuleInfo::MODULE_INFO_INDENTIFIER)) {
            /** @var ModuleInfo $moduleInfo */
            $moduleInfo = $request->getParameter(ModuleInfo::MODULE_INFO_INDENTIFIER);
            foreach ($modules as $module) {
                if ($module->getIdentifier() == $moduleInfo->getIdentifier()) {
                    $module->setCurrentModule(true);
                    $parentActionIdentifier = null;
                    foreach ($module->getAdminModuleActionInfos() as $moduleAction) {
                        if ($moduleAction->getControllerIdentifier() == $moduleInfo->getControllerId() // is same controller
                            && $moduleAction->getMethodName() == $moduleInfo->getAction()) { // is same called method
                            $moduleAction->setCurrentAction(true);
                            $parentActionIdentifier = $moduleAction->getParentActionIdentifier();
                        }
                    }
                    // try to find parent action
                    foreach ($module->getAdminModuleActionInfos() as $moduleAction) {
                        if ($parentActionIdentifier !== null
                            && $moduleAction->getActionIdentifier() == $parentActionIdentifier) {
                            $moduleAction->setParentAction(true);
                        }
                    }
                }
            }
        }

        $model->putParameter("loggedUserModules", $modules);

        // adds info of current module
        $model->putParameter(
            ModuleInfo::MODULE_INFO_INDENTIFIER,
            $moduleInfo
        );
        return $model;
    }
}
