<?php

namespace IZON\Admin\Web\Interceptors;

use IZON\Admin\Services\SessionService;
use IZON\MVC\HttpRequest;
use IZON\MVC\Interceptors\Interceptor;
use IZON\MVC\ModelAndView;

/**
 * zpristupni prihlaseneho uzivatele a prave vybranou zemi pro view
 * @deprecated use LoggedUserCheckInterceptor instead
 */
class LoggedUserInterceptor implements Interceptor
{
    protected SessionService $sessionService;

    /**
     * pod jakym jemnem se ma zpristupnit ve view
     * @var string
     */
    protected $loggedUserModelName = "adminLoggedAdminUser";

    /**
     * @var string
     */
    protected $selectedCountryModelName = "adminSelectedCountry";


    public function __construct(SessionService $sessionService)
    {
        $this->sessionService = $sessionService;
    }

    public function afterCompletion(HttpRequest $request, $exception)
    {
    }

    public function postHandle(HttpRequest $request, ModelAndView $model)
    {
        $loggedUser = $this->sessionService->getLoggedUser();
        $model->putParameter($this->loggedUserModelName, $loggedUser);

        $country = $this->sessionService->getSelectedCountry();
        $model->putParameter($this->selectedCountryModelName, $country);

        return $model;
    }

    public function preHandle(HttpRequest $request)
    {
        return null;
    }
}
