<?php

namespace IZON\Admin\Web\Interceptors;

use IZON\Admin\Config;
use IZON\Admin\Services\LoggedAdminUserSessionService;
use IZON\Logs\Logger;
use IZON\MVC\HttpRequest;
use IZON\MVC\Interceptors\Interceptor;
use IZON\MVC\Interceptors\PreHandleResult;
use IZON\MVC\ModelAndView;

/**
 * tests if there is currently logged user. If not redirect to login page
 */
class LoggedUserCheckInterceptor implements Interceptor
{
    protected LoggedAdminUserSessionService $sessionService;

    protected Logger $log;


    public function __construct(LoggedAdminUserSessionService $sessionService)
    {
        $this->sessionService = $sessionService;

        // logovani
        $this->log = Logger::getLogger(__CLASS__);
    }

    public function afterCompletion(HttpRequest $request, $exception)
    {
    }

    public function postHandle(HttpRequest $request, ModelAndView $model)
    {
        return $model;
    }

    public function preHandle(HttpRequest $request)
    {
        if (!$this->sessionService->isUserLoggedIn()) {
            $this->log->info("User not logged in. Redirect to login page");

            $url = $request->getURL();
            $params = $request->getParameters();
            if (!empty($params)) {
                $serialized = http_build_query($params);
                $url .= '?' . $serialized;
            }

            $preHandleResult = PreHandleResult::getInternalRedirect(Config::LOGIN_CONTROLLER_IDENTIFIER, ['url' => $url]);
            return $preHandleResult;
        }

        if (!$this->sessionService->canBeUserLoggedIn()) { // user can't be logged in
            // logout user
            $this->sessionService->logoutUser();

            // redirect user to login page
            return PreHandleResult::getInternalRedirect(Config::LOGIN_CONTROLLER_IDENTIFIER);
        }

        return null;
    }
}
