<?php


namespace IZON\Admin\Web\Interceptors;

use IZON\MVC\HttpRequest;
use IZON\MVC\Interceptors\Interceptor;
use IZON\MVC\ModelAndView;
use function IZON\MVC\getFileUploadMaxSize;

/**
 *  nacte max povolenou velikost upload souboru v MB pod identifikatorem fileUploadMaxSize a B pod identifikatorem fileUploadMaxSizeB
 */
class LoadMaxFileSizeInterceptor implements Interceptor
{
    public function __construct()
    {
    }

    public function afterCompletion(HttpRequest $request, $exception)
    {
    }

    public function postHandle(HttpRequest $request, ModelAndView $model)
    {
        $model->putParameter("fileUploadMaxSize", getFileUploadMaxSize() / pow(1024, 2));
        $model->putParameter("fileUploadMaxSizeB", getFileUploadMaxSize());
        return $model;
    }

    public function preHandle(HttpRequest $request)
    {
        return null;
    }
}
