<?php

namespace IZON\Admin\Web\Interceptors;

use IZON\Admin\Services\LoggedAdminUserSessionService;
use IZON\MVC\HttpRequest;
use IZON\MVC\Interceptors\Interceptor;
use IZON\MVC\ModelAndView;

/**
 * zpristupni prihlaseneho uzivatele a prave vybranou zemi pro view
 */
class LoadLoggedUserInterceptor implements Interceptor
{
    protected LoggedAdminUserSessionService $sessionService;

    protected string $loggedUserModelName = "adminLoggedAdminUser";


    public function __construct(LoggedAdminUserSessionService $sessionService)
    {
        $this->sessionService = $sessionService;
    }

    public function afterCompletion(HttpRequest $request, $exception)
    {
    }

    public function postHandle(HttpRequest $request, ModelAndView $model)
    {
        $loggedUser = $this->sessionService->getLoggedUser();
        $model->putParameter($this->loggedUserModelName, $loggedUser);
        return $model;
    }

    public function preHandle(HttpRequest $request)
    {
        return null;
    }
}
