<?php

namespace IZON\Admin\Web\Interceptors;

use IZON\Admin\Presentation\Domain\HeaderLink;
use IZON\MVC\HttpRequest;
use IZON\MVC\Interceptors\Interceptor;
use IZON\MVC\ModelAndView;

/**
 * Adds HeaderLink (configured from config) object to view.
 */
class HeaderLinkInterceptor implements Interceptor
{
    public const AVAILABLE_AS = '_izonAdminHeaderLink';

    protected HeaderLink $headerLink;

    public function __construct($controllerUid = '', $params = [])
    {
        $this->headerLink = new HeaderLink($controllerUid, $params);
    }

    public function afterCompletion(HttpRequest $request, $exception)
    {
    }

    public function postHandle(HttpRequest $request, ModelAndView $model)
    {
        $model->putParameter(self::AVAILABLE_AS, $this->headerLink);
    }

    public function preHandle(HttpRequest $request)
    {
        return null;
    }
}
