<?php

namespace IZON\Admin\Web\Interceptors;

use IZON\Admin\Services\LoggedAdminUserSessionService;
use IZON\MVC\HttpRequest;
use IZON\MVC\Interceptors\Interceptor;
use IZON\MVC\ModelAndView;

/**
 * zpristupni prihlaseneho uzivatele pro view
 */
class HandleLoggedUserInterfaceLocaleInterceptor implements Interceptor
{
    protected LoggedAdminUserSessionService $sessionService;

    protected string $supportedInterfaceLocalesViewName = 'supportedInterfaceLocales';

    protected string $selectedUserInterfaceLocaleViewName = 'selectedUserInterfaceLocale';


    public function __construct(LoggedAdminUserSessionService $sessionService)
    {
        $this->sessionService = $sessionService;
    }


    public function afterCompletion(HttpRequest $request, $exception)
    {
    }

    public function postHandle(HttpRequest $request, ModelAndView $model)
    {
        $supportedInterfaceLocales = $this->sessionService->getSupportedInterfaceLocales();
        $model->putParameter($this->supportedInterfaceLocalesViewName, $supportedInterfaceLocales);

        $selectedUserInterfaceLocale = $this->sessionService->getSelectedInterfaceLocale();
        $model->putParameter($this->selectedUserInterfaceLocaleViewName, $selectedUserInterfaceLocale);
    }

    public function preHandle(HttpRequest $request)
    {
        $this->sessionService->setLoggedUserInterfaceLocale();
        return null;
    }
}
