<?php

namespace IZON\Admin\Web\Controllers;

use Exception;
use IZON\Admin\Services\LoggedAdminUserSessionService;
use IZON\MVC\Controller;
use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;

/**
 * switches to selected locale
 */
class SwitchInterfaceLocaleController implements Controller
{
    protected LoggedAdminUserSessionService $sessionService;

    /**
     * @var string na ktery controller se ma presmerovat po znene nastaveni zeme
     */
    protected string $redirectControllerIdentifier;

    /**
     * @var string
     */
    protected $localeTagParamName = "localeTag";


    public function __construct(
        LoggedAdminUserSessionService $sessionService,
        string $redirectControllerIdentifier
    ) {
        $this->sessionService = $sessionService;
        $this->redirectControllerIdentifier = $redirectControllerIdentifier;
    }

    public function execute(HttpRequest $request)
    {
        if (!$request->hasParameter($this->localeTagParamName)) {
            throw new Exception("Neobsahuje parametr countryCode pro změnu jazyka");
        }

        $localeTag = $request->getParameter($this->localeTagParamName);
        $this->sessionService->setSelectedInterfaceLocale($localeTag);

        $modelAndView = ModelAndView::createControllerRedirect($this->redirectControllerIdentifier, []);
        return $modelAndView;
    }
}
