<?php

namespace IZON\Admin\Web\Controllers;

use IZON\Admin\Services\LoggedAdminUserSessionService;
use IZON\MVC\Controller;
use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;

/**
 *
 */
class LogoutController implements Controller
{
    protected LoggedAdminUserSessionService $sessionService;

    protected string $redirectControllerIdentifier;

    /**
     * @param LoggedAdminUserSessionService $sessionService
     * @param string $redirectControllerIdentifier identifier of controller to redirect to after logout
     */
    public function __construct(
        LoggedAdminUserSessionService $sessionService,
        string $redirectControllerIdentifier
    ) {
        $this->sessionService = $sessionService;
        $this->redirectControllerIdentifier = $redirectControllerIdentifier;
    }

    public function logout(HttpRequest $request): ModelAndView
    {
        $this->sessionService->logoutUser();
        return ModelAndView::createControllerRedirect(
            $this->redirectControllerIdentifier,
            []
        );
    }
}
