<?php

namespace IZON\Admin\Web\Controllers;

use IZON\Admin\Services\AdminService;
use IZON\MVC\Controller;
use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;

/**
 * controller, ktery zobrazuje dashboard
 */
class DashboardController implements Controller
{
    protected AdminService $adminService;

    /**
     * jake view se ma pouzit pro zobrazeni formulare
     * @var string
     */
    protected string $dashboardViewName = "admin/dashboard";


    public function __construct(AdminService $adminService)
    {
        $this->adminService = $adminService;
    }

    public function execute(HttpRequest $request)
    {
        return new ModelAndView($this->dashboardViewName);
    }
}
