<?php

namespace IZON\Admin\Services;

use Exception;
use IZON\Admin\Domain\AdminUser;
use IZON\Admin\Presentation\Domain\AdminModuleInfo;
use IZON\DBLocale\Domain\DBCountry;
use IZON\DBLocale\Domain\DBLocale;

/**
 * @deprecated use AdminLoggedUserSessionServiceInterface instead
 */
interface SessionService
{
    /**
     * prihlasi uzivatele nebo vyhodi vyjimu proc to neni mozne
     * @param string $login
     * @param string $password
     */
    public function loginUser($login, $password);

    /**
     * odhlasi v soucasnosti prihlaseneho uzivatele
     */
    public function logoutUser();

    /**
     * vraci true pokud je do aplikace prihlsen uzivatel
     * @return bool
     */
    public function isUserLoggedIn();

    /**
     * returns true if currently logged user can be logged in
     * @return bool
     */
    public function canBeUserLoggedIn();

    /**
     * @return AdminUser currently logged user
     * @throws Exception if user isn't logged in
     */
    public function getLoggedUser();

    /**
     * returns information about modules accessable to currently logged user
     * @return AdminModuleInfo[]
     */
    public function getLoggedUserModules();

    /**
     * @return DBCountry[] countries that user can access
     */
    public function getUserCountries();

    /**
     * vraci prave vybranou zemi pro kterou se provadi editace
     * @return DBCountry
     */
    public function getSelectedCountry();

    /**
     * nastavuje prave vybranou zemi
     */
    public function setSelectedCountry($countryCode);

    /**
     * returns all supported locales for interface of admin
     * @return DBLocale[] Description
     */
    public function getSupportedInterfaceLocales();

    /**
     * returns currently selected locale for admin interface
     * @return DBLocale
     */
    public function getSelectedInterfaceLocale();

    /**
     * nastavuje prave vybranou zemi
     * @param string $localeTag locale tag to set
     */
    public function setSelectedInterfaceLocale($localeTag);

    /**
     * sets locale for loged user
     */
    public function setLoggedUserInterfaceLocale();

    /**
     * vypocita hash hesla podle kterehose potom da vypocitat
     * @param string $password
     */
    public function computePasswordHash($password);
}
