<?php

namespace IZON\Admin\Services\Impl;

use IZON\Admin\Services\AbstractBaseService;
use IZON\Admin\Services\SimpleAdminService;
use IZON\DB\Dao;
use IZON\DB\Paginator\PaginatorConfig;

/**
 * Jesnoducy servis pro vytvoreni editace jedne tridy
 *
 * umoznuje:
 * - natahnout stranky se seznamem polozek
 * - natahnout jednu polozku
 * - ulozit novou polozku
 * - updatovat existujici polozku
 */
class SimpleAdminServiceImpl extends AbstractBaseService implements SimpleAdminService
{
    public function __construct(Dao $dao)
    {
        parent::__construct($dao);
    }

    /**
     * vrati defaultni strankovac
     */
    public function getPaginatorConfig(
        $name = PaginatorConfig::DEFAULT_PAGINATOR_NAME,
        $definedFields = [],
        $maxPageSize = SimpleAdminService::DEFAULT_MAX_PAGE_SIZE
    ) {
        $pagetConfig = new PaginatorConfig($name, $definedFields, $maxPageSize);
        return $pagetConfig;
    }

    /**
     * vrati aktivni moduly
     */
    public function getPage(PaginatorConfig $config)
    {
        return $this->dao->paginate($config);
    }

    /**
     * vrati objekt s danym id nebo vyhodi nenalezeno vyjimky
     * TODO: vytvorit nejakou takovou vijimku v db vrstve
     * @param int $id
     */
    public function get($id)
    {
        return $this->dao->load($id);
    }

    /**
     * Return array of all objects from mapped table
     * @param array $where - array, where key is object property name
     * @param array $orderBy - array, where key is object property name and value is bool - true for ASC, false for DESC
     * @return array
     */
    public function getAll($where = [], $orderBy = [])
    {
        return $this->dao->find($where, $orderBy)->listResult();
    }

    public function update($obj)
    {
        $this->dao->update($obj);
    }

    public function save($obj)
    {
        return $this->dao->save($obj);
    }

    public function delete($id)
    {
        $obj = $this->dao->load($id);
        $this->dao->delete($obj);
    }
}
