<?php

namespace IZON\Admin\Services;

use IZON\Admin\Domain\AdminModule;
use IZON\Admin\Domain\AdminModuleSetting;
use IZON\DBLocale\Domain\DBCountry;
use IZON\DBLocale\Domain\DBLocale;

/**
 * servis, ktery vraci informace o modulech
 */
interface AdminService
{
    /**
     * returns all active modules
     * @return AdminModule[]
     */
    public function getActiveModules();

    /**
     * vrati vsechny podporovane zeme pro soucasny admin
     * @return DBCountry[]
     */
    public function getSupportedCountries();

    /**
     * returns all supported locales for interface of admin
     * @return DBLocale[] Description
     */
    public function getSupportedInterfaceLocales();

    /**
     * @param string $moduleIdentifier
     * @param string $parameterIdentifier
     * @return AdminModuleSetting nastaveni modulu
     *
     */
    public function getModuleSetting($moduleIdentifier, $parameterIdentifier);

    /**
     * @param string $moduleIdentifier
     * @return AdminModuleSetting[] AdminModuleSetting nastaveni modulu
     *
     */
    public function getModuleSettings($moduleIdentifier);

    /**
     * vrati verzi admina
     * @return string
     */
    public function getAdminVersion();
}
