<?php

namespace IZON\Admin\Presentation\Domain;

/**
 * action of module
 */
class AdminModuleActionInfo
{
    /**
     * @var string
     */
    protected $name;

    /**
     * @var string
     */
    protected $actionIdentifier;

    /**
     * @var string
     */
    protected $controllerIdentifier;

    /**
     * @var string
     */
    protected $methodName;

    /**
     * @var array
     */
    protected $parameters = [];

    /**
     * @var string identifier of action this action was called from
     */
    protected $parentActionIdentifier = null;

    /**
     * @var boolean true if this is currently shown action
     */
    protected $currentAction = false;

    /**
     *
     * @var boolean true if this parent of some currently shown action
     */
    protected $parentAction = false;

    /// generated constuctor
    public function __construct($name, $actionIdentifier, $controllerIdentifier, $methodName)
    {
        $this->name = $name;
        $this->actionIdentifier = $actionIdentifier;
        $this->controllerIdentifier = $controllerIdentifier;
        $this->methodName = $methodName;
    }

    public function isCurrentAction()
    {
        return $this->currentAction;
    }

    public function setCurrentAction($currentAction)
    {
        $this->currentAction = $currentAction;
    }

    public function isParentAction()
    {
        return $this->parentAction;
    }

    public function setParentAction($parentAction)
    {
        $this->parentAction = $parentAction;
    }

    public function getActionIdentifier()
    {
        return $this->actionIdentifier;
    }

    /// generated getters and setters
    public function getName()
    {
        return $this->name;
    }

    public function setName($name)
    {
        $this->name = $name;
    }

    public function getControllerIdentifier()
    {
        return $this->controllerIdentifier;
    }

    public function setControllerIdentifier($controllerIdentifier)
    {
        $this->controllerIdentifier = $controllerIdentifier;
    }

    public function getMethodName()
    {
        return $this->methodName;
    }

    public function setMethodName($methodName)
    {
        $this->methodName = $methodName;
    }

    public function getParameters()
    {
        return $this->parameters;
    }

    public function setParameters(array $parameters)
    {
        $this->parameters = $parameters;
    }

    public function getParentActionIdentifier()
    {
        return $this->parentActionIdentifier;
    }

    public function setParentActionIdentifier($parentActionIdentifier)
    {
        $this->parentActionIdentifier = $parentActionIdentifier;
    }
}
