<?php

namespace IZON\Admin\MVC\Views;

use IZON\Logs\Logger;
use IZON\MVC\Views\PHPView;
use IZON\Utils\StringUtils;

/**
 * trida renderujici view, resici cachovani rendrovani view, skladajici view
 * z jednotlivych casti, ...
 * jednotliva view jsou ulozena v adresarich
 * pri devel modu naincluduje nekde dole ve strance misto na debug informace
 *
 * @author David Dryml <dryml@izon.cz>
 * @copyright Copyright 2009, HI Software s.r.o.
 *
 * @package MVC
 */
class AdminPHPView extends PHPView
{
    /**
     * suffix of view file
     */
    public const VIEW_SUFFIX = ".tmpl.php";

    /**
     * suffix of library files
     */
    public const LIBRARY_FILE_SUFFIX = ".php";

    /**
     * @var string[] urls of styles to be autoloaded to admin
     */
    protected array $stylesAutoloadURLs = [];

    /**
     * @var string[] urls of scripts to be autoloaded to admin
     */
    protected array $scriptsAutoloadURLs = [];

    /**
     * vytvari view podle zadaneho jmena a predava mu parametry
     */
    public function __construct($viewPath)
    {
        parent::__construct($viewPath);

        $this->log = Logger::getLogger(self::class);
    }

    /**
     * provede vykresleni celeho view
     */
    public function render()
    {
        // load libraries
        foreach ($this->librariesDirs as $librariesDir) {
            if (file_exists($librariesDir) && is_dir($librariesDir)) { // search only existing folders
                foreach (scandir($librariesDir) as $file) {
                    if (StringUtils::endsWith($file, self::LIBRARY_FILE_SUFFIX)) {
                        require_once $librariesDir . "/" . $file;
                    }
                }
            }
        }

        // render view
        require_once $this->viewPath;
    }


    /// generated getters and setters
    public function getStylesAutoloadURLs(): array
    {
        return $this->stylesAutoloadURLs;
    }

    public function setStylesAutoloadURLs($stylesAutoloadURLs)
    {
        $this->stylesAutoloadURLs = $stylesAutoloadURLs;
    }

    public function getScriptsAutoloadURLs(): array
    {
        return $this->scriptsAutoloadURLs;
    }

    public function setScriptsAutoloadURLs($scriptsAutoloadURLs)
    {
        $this->scriptsAutoloadURLs = $scriptsAutoloadURLs;
    }
}
