<?php

namespace IZON\Admin\MVC\Views;

use Exception;
use IZON\Logs\Logger;

/**
 * trida renderujici view, resici cachovani rendrovani view, skladajici view
 * z jednotlivych casti, ...
 * jednotliva view jsou ulozena v adresarich
 * pri devel modu naincluduje nekde dole ve strance misto na debug informace
 *
 * @author David Dryml <dryml@izon.cz>
 * @copyright Copyright 2009, HI Software s.r.o.
 *
 * @package MVC
 */
class AdminPHPLayoutView extends AdminPHPView
{
    /**
     * suffix of template part file
     */
    public const PART_SUFFIX = ".tmpl.php";

    /**
     * suffix of layout file
     */
    public const LAYOUT_SUFFIX = ".lay.php";

    /**
     * cesty k adresari s views pro jednotlive moduly
     * @var array
     */
    protected array $layoutPartsDirs;

    /**
     * vytvari view podle zadaneho jmena a predava mu parametry
     */
    public function __construct($layoutFilePath, array $layoutPartsDirs)
    {
        parent::__construct($layoutFilePath);

        $this->layoutPartsDirs = $layoutPartsDirs;

        $this->log = Logger::getLogger(self::class);
    }

    /**
     * provede renderovani soucasti graficleho rozhrani
     */
    public function renderLayoutPart($partName)
    {
        $partFilePath = $this->findLayoutPartFilePath($partName);
        require $partFilePath;
    }

    /**
     * najde cestu k potrebne casti grafickeho rozhrani
     */
    protected function findLayoutPartFilePath($partName)
    {
        $this->log->info("Calling findLayoutPartFilePath with parameter: [$partName]");

        $localeTag = $this->getLocale()->toLocaleTag();
        foreach ($this->layoutPartsDirs as $layoutPartDir) {
            $templatePartFilePath = $layoutPartDir . "/" . $partName . "." . $localeTag . self::PART_SUFFIX;
            if (file_exists($templatePartFilePath)
                && is_file($templatePartFilePath)) {
                $this->log->info("Found template $templatePartFilePath");
                return $templatePartFilePath;
            }

            $templatePartFilePath = $layoutPartDir . "/" . $partName . self::PART_SUFFIX;
            if (file_exists($templatePartFilePath)
                && is_file($templatePartFilePath)) {
                $this->log->info("Found template $templatePartFilePath");
                return $templatePartFilePath;
            }
        }

        throw new Exception("Layout part " . $partName . " not found");
    }
}
