<?php

namespace IZON\Admin\MVC;

/**
 * contains info of currently shown module
 */
class ModuleInfo
{
    public const MODULE_INFO_INDENTIFIER = "_moduleInfo";

    /**
     * typ modulu
     * @var string
     */
    protected $type;

    /**
     * unikatni identifikator daneh modulu
     * @var string
     */
    protected $identifier;

    /**
     *
     * @var string
     */
    protected $name;

    /**
     * called controller
     * @var string
     */
    protected $controllerId;

    /**
     *
     * @var string called action of controller
     */
    protected $action;

    /**
     * @var string index of action from moduleActions field vrom module-config.php
     */
    protected $actionIdentifier;

    /**
     * @var string name of action to show
     */
    protected $actionName;

    /**
     * @var string index of action from moduleActions from which was this action called
     */
    protected $parentActionIdentifier;


    /// generovane gettery a settery
    public function getType()
    {
        return $this->type;
    }

    public function setType($type)
    {
        $this->type = $type;
    }

    public function getIdentifier()
    {
        return $this->identifier;
    }

    public function setIdentifier($identifier)
    {
        $this->identifier = $identifier;
    }

    public function getName()
    {
        return $this->name;
    }

    public function setName($name)
    {
        $this->name = $name;
    }

    public function getControllerId()
    {
        return $this->controllerId;
    }

    public function setControllerId($controllerId)
    {
        $this->controllerId = $controllerId;
    }

    public function getAction()
    {
        return $this->action;
    }

    public function setAction($action)
    {
        $this->action = $action;
    }

    public function getActionName()
    {
        return $this->actionName;
    }

    public function setActionName($actionName)
    {
        $this->actionName = $actionName;
    }

    public function getActionIdentifier()
    {
        return $this->actionIdentifier;
    }

    public function setActionIdentifier($actionIdentifier)
    {
        $this->actionIdentifier = $actionIdentifier;
    }

    public function getParentActionIdentifier()
    {
        return $this->parentActionIdentifier;
    }

    public function setParentActionIdentifier($parentActionIdentifier)
    {
        $this->parentActionIdentifier = $parentActionIdentifier;
    }
}
