<?php

namespace IZON\Admin\MVC\Exceptions\Handlers;

use IZON\Admin\MVC\Exceptions\AdminPageNotFoundException;
use IZON\Logs\LogLevel;
use IZON\MVC\Exceptions\Handlers\AppExceptionHandlerInterface;
use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;
use Throwable;

/**
 * Handles if page is not found
 */
class AdminPageNotFoundExceptionHandler implements AppExceptionHandlerInterface
{
    protected string $htmlToShow;

    public function __construct(string $htmlToShow)
    {
        $this->htmlToShow = $htmlToShow;
    }

    public function getLogLevel(): string
    {
        return LogLevel::WARN;
    }

    public function handleException(Throwable $exception, ?HttpRequest $request): ?ModelAndView
    {
        require $this->htmlToShow;
        return null;
    }

    public function isFor(Throwable $exception): bool
    {
        return $exception instanceof AdminPageNotFoundException;
    }
}
