<?php

namespace IZON\Admin\MVC\Context;

use Exception;
use IZON\Admin\MVC\ModuleInfo;
use IZON\Admin\Services\LoggedAdminUserSessionServiceInterface;
use IZON\DBLocale\Domain\DBLocale;
use IZON\MVC\Context\Context;
use IZON\MVC\HttpSession;

/**
 * context specific info for admin
 * contains ModuleInfo of current module, ...
 *
 * @author IZON s.r.o. <info@izon.cz>
 * @copyright Copyright 2017, IZON s.r.o.
 *
 * @package IZON\Admin\MVC\Context
 */
class AdminContext extends Context
{
    protected ?ModuleInfo $moduleInfo;

    protected ?LoggedAdminUserSessionServiceInterface $sessionService;


    /// generated constructor
    public function __construct(
        HttpSession $session,
        ?ModuleInfo $moduleInfo,
        ?LoggedAdminUserSessionServiceInterface $sessionService = null
    ) {
        parent::__construct($session);
        $this->moduleInfo = $moduleInfo;
        $this->sessionService = $sessionService;
    }

    /**
     * @return DbLocale locale currently used for interface of admin
     */
    public function getInterfaceLocale(): DBLocale
    {
        if ($this->sessionService === null) {
            throw new Exception(self::class . ' needs to have $sessionService provided to function prepperly');
        }
        return $this->sessionService->getSelectedInterfaceLocale();
    }

    /// generated getter and setters
    public function getModuleInfo(): ?ModuleInfo
    {
        return $this->moduleInfo;
    }

    public function setModuleInfo(ModuleInfo $moduleInfo)
    {
        $this->moduleInfo = $moduleInfo;
    }

    public function getContextId()
    {
        return "admin";
    }
}
