<?php

namespace IZON\Admin\Domain;

use IZON\DB\DBObject;
use function IZON\DB\transientField;

/**
 * nejaka ztavba na kterou se ma odkazovar
 */
class AdminUser implements DBObject
{
    /**
     * @var null|int
     */
    protected ?int $id = null;

    /**
     * @var string
     */
    protected $firstName;

    /**
     * @var string
     */
    protected $lastName;

    /**
     * @var string
     */
    protected $login;
    /**
     * @var string
     */
    protected $password;

    /**
     * Jestli se aktivni
     * @var boolean
     */
    protected $active;

    /**
     * jestli je superuzivatel tj. ma pristup vsude a ke vsemu
     * @var boolean
     */
    protected $superuser;

    /**
     * @var integer jakou zemi ma mit uzivatel predvibranou pro spravu
     */
    protected $fkCountryId;

    /**
     * @var integer jakou rec si uzivatel vyplnil pro spravu
     */
    protected $fkLanguageId;

    /**
     * @var integer jakym locale se ma uzivateli zobrazovat rozhrani admina
     */
    protected $fkInterfaceLocaleId;

    /**
     * @var AdminRole[]
     */
    protected $roles = [];

    /**
     * nazev tabulky na kterou se mapuje
     */
    public static function __tableName()
    {
        return 'core_admin_users';
    }

    public static function __roles()
    {
        return transientField();
    }


    /// generovane gettery a settery

    public function getFirstName()
    {
        return $this->firstName;
    }

    public function setFirstName($firstName)
    {
        $this->firstName = $firstName;
    }

    public function getLastName()
    {
        return $this->lastName;
    }

    public function setLastName($lastName)
    {
        $this->lastName = $lastName;
    }

    public function getLogin()
    {
        return $this->login;
    }

    public function setLogin($login)
    {
        $this->login = $login;
    }

    public function getPassword()
    {
        return $this->password;
    }

    public function setPassword($password)
    {
        $this->password = $password;
    }

    public function getActive()
    {
        return $this->active;
    }

    public function setActive($active)
    {
        $this->active = $active;
    }

    public function getSuperuser()
    {
        return $this->superuser;
    }

    public function setSuperuser($superuser)
    {
        $this->superuser = $superuser;
    }

    public function getFkCountryId()
    {
        return $this->fkCountryId;
    }

    public function setFkCountryId($fkCountryId)
    {
        $this->fkCountryId = $fkCountryId;
    }

    public function getFkLanguageId()
    {
        return $this->fkLanguageId;
    }

    public function setFkLanguageId($fkLanguageId)
    {
        $this->fkLanguageId = $fkLanguageId;
    }

    public function getRoles()
    {
        return $this->roles;
    }

    public function setRoles(array $roles)
    {
        $this->roles = [];
        foreach ($roles as $role) {
            $this->roles[$role->getId()] = $role;
        }
    }

    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
    }

    public function addRole(AdminRole $role)
    {
        $this->roles[$role->getId()] = $role;
    }

    /**
     * overi, jestli ma prihlazeny uzivatel zadanou roli
     * pro sureusera vzdy vraci true
     *
     * @param AdminRole $role
     * @return boolean
     */
    public function hasRoleByRole(AdminRole $role)
    {
        if ($this->superuser) {
            return true;
        }

        return array_key_exists($role->getId(), $this->roles);
    }

    /**
     * overi, jestli ma prihlazeny uzivatel zadanou roli
     * pro sureusera vzdy vraci true
     *
     * @param int|int[] $roleId
     * @return boolean
     */
    public function hasRoleByRoleId($roleId)
    {
        if ($this->superuser) {
            return true;
        }

        if (!empty($roleId) && is_array($roleId)) {
            foreach ($roleId as $key => $value) {
                if (array_key_exists($value, $this->roles)) {
                    return true;
                }
            }
        } else {
            return array_key_exists($roleId, $this->roles);
        }
        return false;
    }

    /// generated getters and setters
    public function getFkInterfaceLocaleId()
    {
        return $this->fkInterfaceLocaleId;
    }

    public function setFkInterfaceLocaleId($fkInterfaceLocaleId)
    {
        $this->fkInterfaceLocaleId = $fkInterfaceLocaleId;
    }
}
