<?php

namespace IZON\Admin\Domain;

use IZON\DB\DBObject;
use function IZON\DB\transientField;

/**
 * User role in administration
 */
class AdminRole implements DBObject
{
    /**
     * @var null|int
     */
    protected ?int $id = null;

    /**
     * @var string
     */
    protected $name;
    /**
     * @var string
     */
    protected $description;
    /**
     * @var AdminModule[]
     */
    protected $modules = [];

    /**
     * nazev tabulky na kterou se mapuje
     */
    public static function __tableName()
    {
        return 'core_admin_roles';
    }

    public static function __modules()
    {
        return transientField();
    }


    /// generated getters and setters
    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
    }

    public function getName()
    {
        return $this->name;
    }

    public function setName($name)
    {
        $this->name = $name;
    }

    public function getDescription()
    {
        return $this->description;
    }

    public function setDescription($description)
    {
        $this->description = $description;
    }

    public function getModules()
    {
        return $this->modules;
    }

    public function setModules(array $modules)
    {
        $this->modules = $modules;
    }
}
