<?php

namespace IZON\Admin\Domain;

use IZON\DB\DBObject;

/**
 * nejaka ztavba na kterou se ma odkazovar
 */
class AdminModuleSetting implements DBObject
{
    /**
     * @var null|int
     */
    protected ?int $id = null;

    /**
     * @var integer nastaveni ktereho modulu
     */
    protected $fkAdminModuleId;

    /**
     * unikatni identifikator daneh modulu
     * @var string
     */
    protected $paramIdentifier;

    /**
     * @var string hodnota nastaveni
     */
    protected $value;

    /**
     *
     * @var string pojmenovani promene
     */
    protected $name;

    /**
     * nazev tabulky na kterou se mapuje
     */
    public static function __tableName()
    {
        return 'core_admin_module_settings';
    }

    // generovane gettery a settery

    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
    }

    public function getFkAdminModuleId()
    {
        return $this->fkAdminModuleId;
    }

    public function setFkAdminModuleId($fkAdminModuleId)
    {
        $this->fkAdminModuleId = $fkAdminModuleId;
    }

    public function getParamIdentifier()
    {
        return $this->paramIdentifier;
    }

    public function setParamIdentifier($paramIdentifier)
    {
        $this->paramIdentifier = $paramIdentifier;
    }

    public function getValue()
    {
        return $this->value;
    }

    public function setValue($value)
    {
        $this->value = $value;
    }

    public function getName()
    {
        return $this->name;
    }

    public function setName($name)
    {
        $this->name = $name;
    }
}
