<?php

namespace IZON\Admin\Domain;

use IZON\DB\DBObject;
use function IZON\DB\transientField;

/**
 * nejaka ztavba na kterou se ma odkazovar
 */
class AdminModule implements DBObject
{
    /**
     * @var null|int
     */
    protected ?int $id = null;

    /**
     * @var string module type
     */
    protected string $type = '';

    /**
     * unikatni identifikator daneh modulu
     * @var string
     */
    protected $identifier;

    /**
     *
     * @var string
     */
    protected $name;

    /**
     * @var boolean
     */
    protected $enabled;

    /**
     * urcuje, jestli se ma zobrazovat v adminu
     * @var boolean
     */
    protected $adminVisible;

    /**
     * jak se maji moduly seradit
     * @var integer
     */
    protected $moduleOrder;

    /**
     * ikona modulu
     * @var string
     */
    protected $icon;

    /**
     * @var array role ktere mohou k modulu pristupovat
     */
    protected $roles;

    /**
     * @var array nastaveni pro modul
     */
    protected $moduleSettings;

    /**
     * nazev tabulky na kterou se mapuje
     */
    public static function __tableName()
    {
        return 'core_admin_modules';
    }

    public static function __roles()
    {
        return transientField();
    }

    public static function __moduleSettings()
    {
        return transientField();
    }

    /**
     * TODO: az se bude delat uprava co rozbiji spetnou kompatibilitu tak presunout do tabulky
     * @return boolean true is this module is only accessable by superusers
     */
    public function getSuperuserOnlyModule()
    {
        return strstr($this->icon, "superuser") !== false;
    }

    //// generated getters and setters
    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
    }

    public function getType()
    {
        return $this->type;
    }

    public function setType($type)
    {
        $this->type = $type;
    }

    public function getIdentifier()
    {
        return $this->identifier;
    }

    public function setIdentifier($identifier)
    {
        $this->identifier = $identifier;
    }

    public function getName()
    {
        return $this->name;
    }

    public function setName($name)
    {
        $this->name = $name;
    }

    public function getEnabled()
    {
        return $this->enabled;
    }

    public function setEnabled($enabled)
    {
        $this->enabled = $enabled;
    }

    public function getModuleOrder()
    {
        return $this->moduleOrder;
    }

    public function setModuleOrder($moduleOrder)
    {
        $this->moduleOrder = $moduleOrder;
    }

    public function getIcon()
    {
        return $this->icon;
    }

    public function setIcon($icon)
    {
        $this->icon = $icon;
    }

    public function getAdminVisible()
    {
        return $this->adminVisible;
    }

    public function setAdminVisible($adminVisible)
    {
        $this->adminVisible = $adminVisible;
    }

    public function getRoles()
    {
        return $this->roles;
    }

    public function setRoles($roles)
    {
        $this->roles = $roles;
    }

    public function getModuleSettings()
    {
        return $this->moduleSettings;
    }

    public function setModuleSettings($moduleSettings)
    {
        $this->moduleSettings = $moduleSettings;
    }
}
