<?php

namespace IZON\Admin\Dao;

use IZON\Admin\Domain\AdminUser;
use IZON\DB\Dao;
use IZON\DB\QueryResult;

/**
 * @extends Dao<AdminUser>
 */
interface AdminUserDao extends Dao
{
    /**
     * pro jakou tridu se toto dao pouziva
     */
    public const DOMAIN_CLASS = AdminUser::class;

    /**
     * Vraci uzivatele se stejnym loginem
     * @return QueryResult<AdminUser>
     */
    public function findUserByLogin($login): QueryResult;

    /**
     * vrati uzivatel s
     * @return QueryResult<AdminUser>
     */
    public function findUserByAdminRole($roleId): QueryResult;
}
