<?php

namespace IZON\Admin\Dao;

use IZON\Admin\Domain\AdminRole;
use IZON\DB\Dao;
use IZON\DB\QueryResult;

/**
 * @extends Dao<AdminRole>
 */
interface AdminRoleDao extends Dao
{
    /**
     * pro jakou tridu se toto dao pouziva
     */
    public const DOMAIN_CLASS = AdminRole::class;

    /**
     *
     * @param int $userId
     * @return QueryResult<AdminRole> result
     */
    public function findUserRoles($userId): QueryResult;

    /**
     *
     * @param int $moduleId
     * @return QueryResult<AdminRole>
     */
    public function findModuleRoles($moduleId): QueryResult;
}
