<?php

namespace IZON\Admin\Dao;

use IZON\Admin\Domain\AdminModule;
use IZON\DB\Dao;
use IZON\DB\QueryResult;

/**
 * @extends Dao<AdminModule>
 */
interface AdminModuleDao extends Dao
{
    /**
     * pro jakou tridu se toto dao pouziva
     */
    public const DOMAIN_CLASS = AdminModule::class;

    /**
     * Vraci vsechny aktivni moduly
     * @return QueryResult<AdminModule>
     */
    public function findActiveModules(): QueryResult;

    /**
     * Vraci vsechny v adminu viditelne moduly
     * @return QueryResult<AdminModule>
     */
    public function findAdminVisibleModules(): QueryResult;

    /**
     * Vraci vsechny aktivni konstrukce
     * @return QueryResult<AdminModule>
     */
    public function findUserAdminVisibleModules($userId): QueryResult;

    /**
     * returns all modules connected to role
     * @return QueryResult<AdminModule>
     */
    public function findRoleModules($roleId): QueryResult;
}
