<?php

/**
 * funkce pouzivane pri konfiguraci Dependency Injectin
 */

namespace IZON\Admin\DI;

use DI\Definition\EntryReference;
use IZON\Admin\Config;
use IZON\Admin\DI\Definition\Helper\ModuleConfigDefinitionHelper;
use IZON\Admin\DI\Definition\Helper\ModuleConfigsDefinitionHelper;
use IZON\DB\DaoFactoryBean;
use IZON\DI\DI;
use function IZON\DI\factoryBean;
use function IZON\DI\get;

if (!function_exists('IZON\Admin\DI\moduleConfig')) {
    /**
     * nacita informace z nastaveni modulu v db
     * @param string $moduleConfigName nazev konfigurace co se ma vytahnout z konfigurace modulu
     * @return ModuleConfigDefinitionHelper
     */
    function moduleConfig($moduleConfigName, $moduleIdentifier = null)
    {
        // TODO: je celkem ochcavka, udelat lip
        if ($moduleIdentifier == null) {
            $moduleIdentifier = Config::$moduleIdentifier;
        }
        return new ModuleConfigDefinitionHelper(
            $moduleIdentifier,
            $moduleConfigName
        );
    }
}

if (!function_exists('IZON\Admin\DI\moduleConfigs')) {
    /**
     * vsechna nastaveni pro modul
     * @return ModuleConfigsDefinitionHelper
     */
    function moduleConfigs($moduleIdentifier = null)
    {
        // TODO: je celkem ochcavka, udelat lip
        if ($moduleIdentifier == null) {
            $moduleIdentifier = Config::$moduleIdentifier;
        }
        return new ModuleConfigsDefinitionHelper($moduleIdentifier);
    }
}


if (!function_exists('IZON\Admin\DI\moduleGet')) {
    /**
     * Provede načtení hodnoty z modulu
     * podobné jako IZON\DI\get
     *
     * @param string $entryName nazev polozky co se ma vytahnout
     * @param null|string $moduleIdentifier indentifier modulu, z kereho se maji data vytahnout
     *
     * @return EntryReference
     */
    function moduleGet(
        string $entryName,
        ?string $moduleIdentifier = null
    ) {
        $completeEntryName = Config::getModuleEntryName(
            $entryName,
            $moduleIdentifier
        );
        return DI::get($completeEntryName);
    }
}

if (!function_exists('IZON\Admin\DI\moduleIdentifier')) {
    /**
     * vrati identifier $entryName ze zadaneho nebo soucasneho modulu
     *
     * @param string $entryName nazev polozky co se ma vytahnout
     * @param null|string $moduleIdentifier indentifier modulu, z kereho se maji data vytahnout, pokud je null bere se identifier ze soucasneho modulu
     *
     * @return string
     */
    function moduleIdentifier(
        string $entryName,
        ?string $moduleIdentifier = null
    ): string {
        return Config::getModuleEntryName(
            $entryName,
            $moduleIdentifier
        );
    }
}

if (!function_exists('IZON\Admin\DI\currentModuleIdentifier')) {
    /**
     * returns identifier of module that is currentky configured
     * @return string
     */
    function currentModuleIdentifier(): string
    {
        return Config::getCurrentModuleIdentifier();
    }
}

if (!function_exists('IZON\Admin\DI\modulesDirs')) {
    /**
     * returns directories of all installed modules
     */
    function modulesDirs()
    {
        return DI::get(Config::MODULES_DIRS_IDENTIFIER);
    }
}

if (!function_exists('IZON\Admin\DI\daoInit')) {
    /**
     *
     * @param array $configArray konfigurace, ktera se pouzije
     * @param string $dbConnectionId pod jekym id je ulozeno db pripojeni
     * @param array|string $daoClasses tridy interface, ktere se maji inicializovat
     * @return array konfiguracni pole s pridanymi dai
     * @deprecated Do not use not necessary anymore as DAOs are initialized automatically
     */
    function daoInit(
        $configArray,
        $dbConnectionId,
        $daoClasses
    ) {
        foreach ($daoClasses as $daoClass) {
            $configArray[$daoClass] = factoryBean(DaoFactoryBean::class)
                ->constructor(get($dbConnectionId), $daoClass);
        }
        return $configArray;
    }
}

if (!function_exists('IZON\Admin\DI\daoModuleInit')) {
    /**
     * Inicializace dai pro modul
     *
     * @param array $configArray
     * @param string $baseDir - jakeho adresare se budou daa nacitat
     * @param string $namespace namespace bez prvniho \
     * @param string $dbConnectionId
     * @param null|array $externalDaoClasses - pokud chceme nacitat enajaka externi daa
     * @return array
     * @deprecated Do not use not necessary anymore as DAOs are initialized automatically
     */
    function daoModuleInit($configArray, $baseDir, $namespace, $dbConnectionId, $externalDaoClasses = [])
    {
        if (!empty($externalDaoClasses) && is_array($externalDaoClasses)) { // @phpstan-ignore function.alreadyNarrowedType
            foreach ($externalDaoClasses as $daoClass) {
                $configArray[$daoClass] = factoryBean(DaoFactoryBean::class)
                    ->constructor(DI::get($dbConnectionId), $daoClass);
            }
        }
        $path = $baseDir . 'src/Dao';
        foreach (scandir($path) as $file) {
            if (in_array($file, ['.', '..'])) {
                continue;
            }
            $daoClass = $namespace . pathinfo($file, PATHINFO_FILENAME);
            $configArray[$daoClass] = factoryBean(DaoFactoryBean::class)
                ->constructor(get($dbConnectionId), $daoClass);
        }

        return $configArray;
    }
}

if (!function_exists('IZON\Admin\DI\useModuleInit')) {
    /**
     * Nasype potrebna daa, servisy a controlerry do module-config.php
     *
     * @param string $baseDir zakladni adresar
     * @param string $namespace
     * @param null|array $dirs pole s adresari, pro ktere chceme generovat "use"
     * @deprecated Do not use not necessary anymore as DAOs are initialized automatically
     */
    function useModuleInit($baseDir, $namespace, $dirs)
    {
        $buff = [];
        $fileContent = file_get_contents($baseDir . 'module-config.php');
        if (!empty($dirs) && is_array($dirs)) { // @phpstan-ignore function.alreadyNarrowedType
            foreach ($dirs as $key => $dir) {
                $path = $baseDir . 'src/' . str_replace("\\", "/", $dir);

                foreach (scandir($path) as $file) {
                    if (pathinfo($file, PATHINFO_EXTENSION) != 'php') {
                        continue;
                    }//  in_array($file, array('.', '..'))
                    $buff[] = 'use ' . $namespace . $dir . '\\' . pathinfo($file, PATHINFO_FILENAME) . ';';
                }
                $buff[] = "\r\n";
            }
        }

        $startSign = '// --- START USE SECTION ---';
        $endSign = '// --- END USE SECTION ---';
        $startSection = strpos($fileContent, $startSign);
        if ($startSection !== false) {
            $endSection = strpos($fileContent, $endSign);
            if ($endSection !== false) {
                $before = substr($fileContent, 0, $startSection + strlen($startSign));
                $after = substr($fileContent, $endSection);
                $fileContent = $before . "\r\n" . implode("\r\n", $buff) . "\r\n" . $after;
                //echo $fileContent;
                //die;
                file_put_contents($baseDir . 'module-config.php', $fileContent);
            }
        }
    }
}
