<?php

namespace IZON\Admin\DI;

use DI\Definition\Source\DefinitionSource;
use DI\FactoryInterface;
use DI\InvokerInterface;
use DI\Proxy\ProxyFactory;
use IZON\Admin\DI\Definition\Resolver\ResolverDispatcher;
use IZON\DI\Container;
use Psr\Container\ContainerInterface;

/**
 * Container pro pristup k modulum
 *
 * upravena trida z DI\Container
 *
 */
class ModulesAwareContainer extends Container implements ContainerInterface, FactoryInterface, InvokerInterface
{
    /**
     * Use the ContainerBuilder to ease constructing the Container.
     *
     * @param DefinitionSource $definitionSource
     * @param ProxyFactory $proxyFactory
     * @param null|ContainerInterface $wrapperContainer If the container is wrapped by another container.
     * @see ContainerBuilder
     *
     */
    public function __construct(
        DefinitionSource $definitionSource,
        ProxyFactory $proxyFactory,
        ?ContainerInterface $wrapperContainer = null
    ) {
        parent::__construct($definitionSource, $proxyFactory, $wrapperContainer);

        $this->definitionResolver = new ResolverDispatcher($this->wrapperContainer, $proxyFactory);
    }
}
