<?php

namespace IZON\Admin\DI\Definition\Resolver;

use DI\Definition\Definition;
use DI\Definition\Resolver\DefinitionResolver;
use IZON\Admin\DI\Definition\ModuleConfigDefinition;
use IZON\Admin\DI\Definition\ModuleConfigsDefinition;
use IZON\DI\Definition\Resolver\ResolverDispatcher as IZONDIResolverDispatcher;
use RuntimeException;

/**
 * Container pro pristup k predkum
 *
 * upravena trida z \DI\Definition\Resolver\DefinitionResolver
 *
 */
class ResolverDispatcher extends IZONDIResolverDispatcher implements DefinitionResolver
{
    /**
     * @var null|ModuleConfigResolver
     */
    protected $moduleConfigResolver = null;

    /**
     * @var null|ModuleConfigsResolver
     */
    protected $moduleConfigsResolver = null;


    /**
     * Returns a resolver capable of handling the given definition.
     *
     * @param Definition $definition
     *
     * @return DefinitionResolver
     * @throws RuntimeException No definition resolver was found for this type of definition.
     */
    protected function getDefinitionResolver(Definition $definition)
    {
        switch (true) {
            case $definition instanceof ModuleConfigDefinition:
                if (!$this->moduleConfigResolver) {
                    $this->moduleConfigResolver = new ModuleConfigResolver($this->container);
                }
                return $this->moduleConfigResolver;
            case $definition instanceof ModuleConfigsDefinition:
                if (!$this->moduleConfigsResolver) {
                    $this->moduleConfigsResolver = new ModuleConfigsResolver($this->container);
                }
                return $this->moduleConfigsResolver;
            default:
                return parent::getDefinitionResolver($definition);
        }
    }
}
