<?php

namespace IZON\Admin\DI\Definition;

use DI\Definition\Definition;
use DI\Scope;

/**
 * definice pro ziskani konfigurace modulu
 */
class ModuleConfigDefinition implements Definition
{
    protected $moduleIdentifier;
    protected $paramIdentifier;
    private string $name;

    /**
     * @param string $name Entry name
     * @param string $moduleIdentifier
     * @param string $paramIdentifier
     */
    public function __construct($name, $moduleIdentifier, $paramIdentifier)
    {
        $this->name = $name;
        $this->moduleIdentifier = $moduleIdentifier;
        $this->paramIdentifier = $paramIdentifier;
    }

    /**
     * @return string Entry name
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * {@inheritdoc}
     */
    public function getScope()
    {
        return Scope::SINGLETON;
    }

    public function getModuleIdentifier()
    {
        return $this->moduleIdentifier;
    }

    public function getParamIdentifier()
    {
        return $this->paramIdentifier;
    }
}
