<?php

namespace IZON\Admin\DI\Definition\Helper;

use DI\Definition\Helper\DefinitionHelper;
use IZON\Admin\DI\Definition\ModuleConfigDefinition;

/**
 * Helps load module configuration
 */
class ModuleConfigDefinitionHelper implements DefinitionHelper
{
    /**
     * @var string identifikator modulu pod kterym se nachazi
     */
    protected string $moduleIdentifier;

    /**
     * @var string indentifikator parametru pod kterym se hodnota parametru nachazi
     */
    protected string $paramIdentifier;

    public function __construct(string $moduleIdentifier, string $paramIdentifier)
    {
        $this->moduleIdentifier = $moduleIdentifier;
        $this->paramIdentifier = $paramIdentifier;
    }

    /**
     * @param string $entryName Container entry name
     */
    public function getDefinition($entryName)
    {
        return new ModuleConfigDefinition(
            $entryName,
            $this->moduleIdentifier,
            $this->paramIdentifier
        );
    }
}
