<?php

namespace IZON\Admin\DB;

use IZON\Admin\Domain\AdminUserRole;
use IZON\DB\QueryHelpers;

return [
    "findUserByLogin_1" => [
        'queryFactory' => function (QueryHelpers $queryHelpers) {
            $sql = "
                SELECT {$queryHelpers->getClassProperties("u")}
                FROM {$queryHelpers->getTableName("u")}
                WHERE {$queryHelpers->getColumnName("login")} = {$queryHelpers->getParameterName(0)}
                LIMIT :maxResults
                OFFSET :firstResult
             ";
            return $sql;
        }
    ],

    "findUserByAdminRole_1" => [
        'queryFactory' => function (QueryHelpers $queryHelpers) {
            $userAlias = $queryHelpers->createTableAlias('u');
            $userRoleAlias = $queryHelpers->createTableAlias('ur', AdminUserRole::class);

            $sql = "
                SELECT {$queryHelpers->getClassProperties("u")}
                FROM {$queryHelpers->getTableName("u")}
                    join {$userRoleAlias->getTableName()}
                        on {$userAlias->getColumnName("id")} = {$userRoleAlias->getColumnName("fkAdminUserId")}
                WHERE {$userRoleAlias->getColumnName("fkAdminRoleId")} = {$queryHelpers->getParameterName(0)}
                LIMIT :maxResults
                OFFSET :firstResult
            ";

            return $sql;
        }
    ]
];
