<?php

namespace IZON\Admin\DB;

use IZON\Admin\Domain\AdminRoleModule;
use IZON\Admin\Domain\AdminUserRole;
use IZON\DB\QueryHelpers;

return [
    /**
     * returns all roles for user
     */
    "findUserRoles_1" => [
        'queryFactory' => function (QueryHelpers $queryHelpers) {
            $roleAlias = $queryHelpers->createTableAlias("r");
            $userRoleAlias = $queryHelpers->createTableAlias("ur", AdminUserRole::class);
            return "
                SELECT {$roleAlias->getClassProperties()}
                FROM {$roleAlias->getTableName()}
                    JOIN {$userRoleAlias->getTableName()}
                        ON {$roleAlias->getColumnName("id")}
                            = {$userRoleAlias->getColumnName("fkAdminRoleId")}
                WHERE {$userRoleAlias->getColumnName("fkAdminUserId")} = {$queryHelpers->getParameterName(0)}
                LIMIT :maxResults
                OFFSET :firstResult
            ";
        }
    ],

    /**
     * returns all soles for module
     */
    "findModuleRoles_1" => [
        'queryFactory' => function (QueryHelpers $queryHelpers) {
            $roleAlias = $queryHelpers->createTableAlias("r");
            $roleModuleAlias = $queryHelpers->createTableAlias("rm", AdminRoleModule::class);
            return "
                SELECT {$roleAlias->getClassProperties()}
                FROM {$roleAlias->getTableName()}
                    JOIN {$roleModuleAlias->getTableName()}
                        ON {$roleAlias->getColumnName("id")} = {$roleModuleAlias->getColumnName("fkAdminRoleId")}
                WHERE {$roleModuleAlias->getColumnName("fkAdminModuleId")} = {$queryHelpers->getParameterName(0)}
                LIMIT :maxResults
                OFFSET :firstResult
            ";
        }
    ]
];
