<?php

use IZON\Admin\Domain\AdminRoleModule;
use IZON\Admin\Domain\AdminUserRole;
use IZON\DB\QueryHelpers;

return [
    /**
     * Vraci vsechny aktivni moduly
     * @param QueryHelpers $queryHelpers
     */
    "findActiveModules_0" => [
        'cacheResult' => false,
        'queryFactory' => function (QueryHelpers $queryHelpers) {
            $module = $queryHelpers->createTableAlias('m');
            return "
                SELECT {$module->getColumnNames()}
                FROM {$module->getTableName()}
                WHERE {$module->getColumnName('enabled')} = 1
                ORDER BY {$module->getColumnName('moduleOrder')} ASC
                LIMIT :maxResults OFFSET :firstResult
            ";
        },
    ],

    /**
     * Vraci vsechny viditelne moduly v adminu
     * @param QueryHelpers $queryHelpers
     */
    "findAdminVisibleModules_0" => [
        'queryFactory' => function (QueryHelpers $queryHelpers) {
            $module = $queryHelpers->createTableAlias('m');
            return "
                SELECT {$module->getColumnNames()}
                FROM {$module->getTableName()}
                WHERE {$module->getColumnName('enabled')} = 1
                    AND {$module->getColumnName('adminVisible')} = 1
                ORDER BY {$module->getColumnName('moduleOrder')} ASC
                LIMIT :maxResults OFFSET :firstResult
            ";
        }
    ],

    "findUserAdminVisibleModules_1" => [
        'queryFactory' => function (QueryHelpers $queryHelpers) {
            $module = $queryHelpers->createTableAlias('m');
            $roleModule = $queryHelpers->createTableAlias('rm', AdminRoleModule::class);
            $userRole = $queryHelpers->createTableAlias('ur', AdminUserRole::class);
            $query = "
                SELECT DISTINCT {$module->getColumnNames()}
                FROM {$module->getTableName()}
                JOIN {$roleModule->getTableName()}
                    ON {$module->getColumnName('id')} = {$roleModule->getColumnName('fkAdminModuleId')}
                JOIN {$userRole->getTableName()}
                    ON {$roleModule->getColumnName('fkAdminRoleId')} = {$userRole->getColumnName('fkAdminRoleId')}
                WHERE {$module->getColumnName('enabled')} = 1
                    AND {$module->getColumnName('adminVisible')} = 1
                    AND {$userRole->getColumnName('fkAdminUserId')} = {$queryHelpers->getParameterName(0)}
                ORDER BY {$module->getColumnName('moduleOrder')} ASC
                LIMIT :maxResults OFFSET :firstResult
            ";
            //        var_dump($query);
            return $query;
        }
    ],

    "findRoleModules_1" => [
        'queryFactory' => function (QueryHelpers $queryHelpers) {
            $module = $queryHelpers->createTableAlias('m');
            $roleModule = $queryHelpers->createTableAlias('rm', AdminRoleModule::class);
            $query = "
                SELECT DISTINCT {$module->getColumnNames()}
                FROM {$module->getTableName()}
                JOIN {$roleModule->getTableName()}
                    ON {$module->getColumnName('id')} = {$roleModule->getColumnName('fkAdminModuleId')}
                WHERE {$roleModule->getColumnName('fkAdminRoleId')} = {$queryHelpers->getParameterName(0)}
                LIMIT :maxResults OFFSET :firstResult
            ";
            //        var_dump($query);
            return $query;
        }
    ]
];
