<?php

namespace IZON\Admin\Config;

use IZON\Admin\Config;
use IZON\Admin\Dao\AdminModuleDao;
use IZON\Admin\Dao\AdminModuleSettingDao;
use IZON\Admin\Dao\AdminRoleDao;
use IZON\Admin\Dao\AdminRoleModuleDao;
use IZON\Admin\Dao\AdminUserDao;
use IZON\Admin\Dao\AdminUserRoleDao;
use IZON\Admin\Services\Impl\AdminServiceImpl;
use IZON\Admin\Services\LoggedAdminUserSessionService;
use IZON\Admin\Services\LoggedAdminUserSessionServiceInterface;
use IZON\Admin\Web\Controllers\DashboardController;
use IZON\Admin\Web\Controllers\LoginController;
use IZON\Admin\Web\Controllers\LogoutController;
use IZON\Admin\Web\Controllers\NotificationsController;
use IZON\Admin\Web\Controllers\SwitchInterfaceLocaleController;
use IZON\Admin\Web\Interceptors\HandleLoggedUserInterfaceLocaleInterceptor;
use IZON\Admin\Web\Interceptors\HeaderLinkInterceptor;
use IZON\Admin\Web\Interceptors\LoadAdminVersionInterceptor;
use IZON\Admin\Web\Interceptors\LoadLoggedUserInterceptor;
use IZON\Admin\Web\Interceptors\LoadMaxFileSizeInterceptor;
use IZON\Admin\Web\Interceptors\LoggedUserCheckInterceptor;
use IZON\Admin\Web\Interceptors\LoggedUserModulesInterceptor;
use IZON\DB\DaoFactoryBean;
use IZON\DBLocale\Dao\DBCountryDao;
use IZON\DBLocale\Dao\DBCurrencyDao;
use IZON\DBLocale\Dao\DBLanguageDao;
use IZON\DBLocale\Dao\DBLocaleDao;
use IZON\DI\DI;
use IZON\MVC\Controllers\SimpleErrorController;
use function IZON\Admin\DI\modulesDirs;
use function IZON\DI\factoryBean;

return [
    /// inicializace pod tridami rozhrani aby fungoval autoresolve
    AdminModuleDao::class => factoryBean(DaoFactoryBean::class)
        ->constructor(DI::get('db.connection'), AdminModuleDao::class),
    AdminUserDao::class => factoryBean(DaoFactoryBean::class)
        ->constructor(DI::get('db.connection'), AdminUserDao::class),
    AdminRoleDao::class => factoryBean(DaoFactoryBean::class)
        ->constructor(DI::get('db.connection'), AdminRoleDao::class),
    AdminUserRoleDao::class => factoryBean(DaoFactoryBean::class)
        ->constructor(DI::get('db.connection'), AdminUserRoleDao::class),
    AdminModuleSettingDao::class => factoryBean(DaoFactoryBean::class)
        ->constructor(DI::get('db.connection'), AdminModuleSettingDao::class),
    AdminRoleModuleDao::class => factoryBean(DaoFactoryBean::class)
        ->constructor(DI::get('db.connection'), AdminRoleModuleDao::class),

    'izon.admin.dao.adminModuleDao' => factoryBean(DaoFactoryBean::class)
        ->constructor(DI::get('db.connection'), AdminModuleDao::class),
    'izon.admin.dao.adminUserDao' => factoryBean(DaoFactoryBean::class)
        ->constructor(DI::get('db.connection'), AdminUserDao::class),
    'izon.admin.dao.adminRoleDao' => factoryBean(DaoFactoryBean::class)
        ->constructor(DI::get('db.connection'), AdminRoleDao::class),
    'izon.admin.dao.adminUserRoleDao' => factoryBean(DaoFactoryBean::class)
        ->constructor(DI::get('db.connection'), AdminUserRoleDao::class),
    'izon.admin.dao.adminModuleSettingDao' => factoryBean(DaoFactoryBean::class)
        ->constructor(DI::get('db.connection'), AdminModuleSettingDao::class),

    'izon.admin.dao.CountryDao' => factoryBean(DaoFactoryBean::class)
        ->constructor(DI::get('db.connection'), DBCountryDao::class),

    'izon.admin.dao.localeDao' => factoryBean(DaoFactoryBean::class)
        ->constructor(DI::get('db.connection'), DBLocaleDao::class),

    'izon.admin.dao.languageDao' => factoryBean(DaoFactoryBean::class)
        ->constructor(DI::get('db.connection'), DBLanguageDao::class),

    'izon.admin.dao.currencyDao' => factoryBean(DaoFactoryBean::class)
        ->constructor(DI::get('db.connection'), DBCurrencyDao::class),

    Config::ADMIN_SERVICE_IDENTIFIER => DI::autowire(AdminServiceImpl::class)
        ->constructor(
            DI::get('izon.admin.dao.adminModuleDao'),
            DI::get('izon.admin.dao.adminModuleSettingDao'),
            DI::get('izon.admin.dao.localeDao'),
            DI::get('izon.admin.dao.CountryDao'),
            DI::get('izon.admin.dao.languageDao')
        )
        ->method("setSupportedInterfaceLocaleIdes", DI::get('locale.admin.supportedAdminInterfaceLocaleIdes')),

    // TODO: umoznit jeho prepsani v configu
    'izon.admin.service.adminSessionService' => DI::autowire(LoggedAdminUserSessionService::class)
        ->constructor(
            DI::get(Config::ADMIN_SERVICE_IDENTIFIER),
            DI::get(Config::CONFIG_DIR_IDENTIFIER),
            DI::get("admin.modulesActions"),
            modulesDirs(),
            DI::get('locale.dir'),
            DI::get('locale.tempDir'),
            DI::get('izon.admin.dao.adminUserDao'),
            DI::get('izon.admin.dao.adminRoleDao'),
            DI::get('izon.admin.dao.adminModuleDao'),
            DI::get('izon.admin.dao.CountryDao'),
            DI::get('izon.admin.dao.localeDao'),
            DI::get('izon.admin.dao.languageDao'),
            DI::get('izon.admin.dao.currencyDao')
        )
        ->method('setUniversalPasswordHash', DI::get('admin.universalPasswordHash'))
        ->method("setRoleSupportedCountries", DI::get('admin.roleSupportedCountries')),
    LoggedAdminUserSessionServiceInterface::class => DI::get('izon.admin.service.adminSessionService'),

    //// controllery pro admin
    // controller pro prihlaseni a odhlaseni
    Config::LOGIN_CONTROLLER_IDENTIFIER => DI::autowire(LoginController::class)
        ->constructor(
            DI::get('izon.admin.service.adminSessionService'),
            Config::DASHBOARD_CONTROLLER_IDENTIFIER
        ),

    // controller pro uvodku adminu
    Config::DASHBOARD_CONTROLLER_IDENTIFIER => DI::autowire(DashboardController::class)
        ->constructor(
            DI::get(Config::ADMIN_SERVICE_IDENTIFIER)
        ),

    // controller pro odhlaseni z admina
    Config::LOGOUT_CONTROLLER_IDENTIFIER => DI::autowire(LogoutController::class)
        ->constructor(
            DI::get('izon.admin.service.adminSessionService'),
            Config::LOGIN_CONTROLLER_IDENTIFIER
        ),

//    // controller pro zmenu jazyka
//    Config::SWITCH_COUNTRY_CONTROLLER_IDENTIFIER => DI::autowire(SwitchCountryController::class)
//        ->constructor(
//            DI::get('izon.admin.service.adminSessionService'),
//            Config::DASHBOARD_CONTROLLER_IDENTIFIER
//        ),

    // controller pro zmenu jazyka
    Config::SWITCH_INTERFACE_LOCALE_CONTROLLER_IDENTIFIER => DI::autowire(SwitchInterfaceLocaleController::class)
        ->constructor(
            DI::get('izon.admin.service.adminSessionService'),
            Config::DASHBOARD_CONTROLLER_IDENTIFIER
        ),

    // controller pro spravu notifikaci
    Config::NOTIFICATIONS_CONTROLLER_IDENTIFIER => DI::autowire(NotificationsController::class)
        ->constructor(DI::get(Config::ADMIN_SERVICE_IDENTIFIER)),

    Config::MODULE_ACCESS_FORBIDDEN_ERROR_CONTROLLER_IDENTIFIER => DI::autowire(SimpleErrorController::class)
        ->constructor(
            'admin/module-access-forbidden',
            403
        ),

    //// interceptory pro admin
    // interceptor pro kontrolu prihlaseneho uzivatele
    Config::LOGGED_USER_CHECK_INTERCEPTOR_IDENTIFIER => DI::autowire(LoggedUserCheckInterceptor::class)
        ->constructor(DI::get('izon.admin.service.adminSessionService')),

    Config::ADMIN_HEADER_LINK_INTERCEPTOR_IDENTIFIER => DI::autowire(HeaderLinkInterceptor::class)
        ->constructor(
            DI::get('izon.admin.headerLink.controllerUid'),
            DI::get('izon.admin.headerLink.params')
        ),

    // interceptor pro nacteni prihlaseneho uzivatele
    Config::HANDLE_LOGGED_USER_INTERFACE_LOCALE_INTERCEPTOR => DI::autowire(HandleLoggedUserInterfaceLocaleInterceptor::class)
        ->constructor(DI::get('izon.admin.service.adminSessionService')),

    // interceptor pro nacteni prihlaseneho uzivatele
    Config::LOGGED_USER_INTERCEPTOR_IDENTIFIER => DI::autowire(LoadLoggedUserInterceptor::class)
        ->constructor(DI::get('izon.admin.service.adminSessionService')),

    // interceptor pro nacteni akci admina
    Config::MODULES_ACTIONS_INTERCEPTOR_IDENTIFIER => DI::autowire(LoggedUserModulesInterceptor::class)
        ->constructor(
            DI::get('izon.admin.service.adminSessionService'),
            DI::get('admin.modulesActions')
        ),

//    // interceptor pro nacteni akci admina
//    Config::MODULES_SUPPORTED_COUNTRIES_INTERCEPTOR_IDENTIFIER => DI::autowire(SupportedCountriesInterceptor::class)
//        ->constructor(DI::get('izon.admin.service.adminSessionService')),

    // nacte verzi admina
    Config::ADMIN_VERSION_INTERCEPTOR_IDENTIFIER => DI::autowire(LoadAdminVersionInterceptor::class)
        ->constructor(DI::get(Config::ADMIN_SERVICE_IDENTIFIER)),

    //nacte max file size
    Config::ADMIN_MAX_FILE_SIZE_INTERCEPTOR_IDENTIFIER => DI::autowire(LoadMaxFileSizeInterceptor::class),
];
