<?php

namespace IZON\Admin\DB;

use IZON\DB\QueryHelpers;
use IZON\DB\QueryFactory;

/**
 * 
 */
class AdminUserQueryFactory implements QueryFactory {
    
    /**
     * Vraci vsechny aktivni konstrukce
     * @param QueryHelpers
     */
    public function findUserByLogin_1(QueryHelpers $queryHelpers) {
        $sql = 'select '. $queryHelpers->getClassProperties("u")  
               .' from '. $queryHelpers->getTableName("u") 
               .' where '. $queryHelpers->getCoumnName("login") ." = :arg0  limit :maxResults offset :firstResult";
        return $sql;
    }
    
    /**
     * Vraci vsechny aktivni konstrukce
     * @param QueryHelpers
     */
    public function findUserByAdminRole_1(QueryHelpers $queryHelpers) {
        $userAlias = $queryHelpers->createTableAlias('u');
        $userRoleAlias = $queryHelpers->createTableAlias('ur', \IZON\Admin\Domain\AdminUserRole::class);
        $sql = 'select '. $queryHelpers->getClassProperties("u")  
               .' from '. $queryHelpers->getTableName("u") 
                    ." join ". $userRoleAlias->getTableName()
                        ." on ". $userAlias->getColumnName("id") ." = ". $userRoleAlias->getColumnName("fkAdminUserId") 
               .' where '. $userRoleAlias->getColumnName("fkAdminRoleId") ." = ". $queryHelpers->getParameterName(0)
               ."  limit :maxResults offset :firstResult";
        
//        echo $sql;
//        die;
        return $sql;
    }
    
}
