<?php

namespace IZON\Admin\Web\Controllers;

use IZON\MVC\Controller;
use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;
use IZON\IO\File;
use IZON\IO\Image;
use IZON\Forms\Form;

use IZON\Admin\Services\AbstractBaseService;

abstract class AbstractBaseController {
    
    /**
     * @var AbstractBaseService
     */
    protected $service;
    
    /**
     * @var string v jakem adresari se nachazeji docasne soubory nahravane
     */
    protected $filesFolder = "files"; 
    /**
     *
     * @var string preffix pro formulare kde je ukladaji obrazky
     */
    protected $imagesPrefix = "images";
    /**
     *
     * @var string preffix pro formulare kde je ukladaji obrazky
     */
    protected $filesPrefix = "files";
    
    /**
     * Declare data type depend of mineType
     * @var array 
     */
    protected $dataTypes = [
        'text/plain' => 'txt',
        'image/jpeg' => 'jpg',
        'application/zip' => 'zip',
        'video/mp4' => 'mp4',
        'video/mpeg' => 'mpeg',
        'video/avi' => 'mpeg',
        'application/mspowerpoint' => 'powerpoint',
        'application/excel' => 'excel',
        'application/x-excel' => 'excel',
        'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' => 'excel',
        'application/msword'=>'msword',
        'application/pdf' => 'pdf'
    ];
    
    /**
     *
     * @var HttpRequest
     */
    protected $request;
    
    function __construct(AbstractBaseService $service) {
        $this->service = $service;
    }
    
//    
//    
//    abstract function execute(HttpRequest $request);
//    
//    abstract function edit(HttpRequest $request);
//    
//    abstract function save(HttpRequest $request);
//    
//    
    
    public function changeProperty(HttpRequest $request) {
        if ($request->hasParameter('propertyName')) {
            $this->service->changeSimpleProperty($request->getParameter('id'), $request->getParameter('propertyName'));
        }

        $mav = ModelAndView::createControllerRedirect($request->getCalledControllerId(), ["action" => "execute"]); // presmerovavat na senam
        return $mav;
    }
    
    public function ajaxUploadFile(HttpRequest $request) {
        $id = $request->getParameter("id");
        if( !$id ) {
            $id = 0;
        }
        
        // kde je soubor ulozen
        $fileURI = $_FILES["file"]["tmp_name"];
        // ciste jmeno
        $fileName = File::getSafeFileName($_FILES["file"]["name"]);
        $fileFolder = uniqid();
        
        // presun do temporary souboru
        // TODO: udelat nejak inteligentneji, aby se dano nastavovat
        $tempFileDir = $this->getFileUploadTempDir() ."/". $fileFolder;
        if( !file_exists($tempFileDir) ) {
            // vytvor temporry 
            mkdir($tempFileDir, 0770, true);
        }
        $tempFileName = $tempFileDir ."/". $fileName;
        move_uploaded_file($fileURI, $tempFileName);
        
        $mineType = mime_content_type($tempFileName);
        $dataType = $this->dataTypes[$mineType];
        
        $retval = ["id" => $fileFolder ."/". $fileName,
                    "fileName" => $fileName,
                    "description" => '', 
                    "fileURL" => $fileFolder ."/". $fileName,
                    'mineType' => $mineType,
                    'dataType' => $dataType
                ];
        
        $modelAndView = new ModelAndView("admin/simple/json-respose");
        $modelAndView->putParameter("json", $retval);
        
        return $modelAndView;
    }
    
    protected function getFileUploadTempDir() {
        return __BASE_DIR__ ."/app-data/tmp/user-data/". session_id() ."/". $this->filesFolder;
    }
    
    public function ajaxGetFileContent(HttpRequest $request) {
        $imgURL = $request->getParameter("imgURL");
        $file = $this->getFileUploadTempDir() ."/". $imgURL;
        $image = new File($file);
        
        $modelAndView = new ModelAndView("admin/raw-data");
        $modelAndView->putParameter("contentType", $image->getMineType());
        $modelAndView->putParameter("data", file_get_contents($file));
        
        return $modelAndView;
    }
    
    
    /**
     * smaze obsah adresare kompletne rekurzivne
     * @param string $dir
     */
    protected function deleteRecursivelly($dir = null) {
        if($dir == null){
            $dir = $this->getFileUploadTempDir();
        }
        if( !file_exists($dir) ) {
            return;
        }
        foreach(scandir($dir) as $subFile) {
            $absFileDir = $dir ."/". $subFile;
            
            if( is_dir($absFileDir) ) {
                if( $subFile != "."
                    && $subFile != "..") {
                    $this->deleteRecursivelly($absFileDir);
                    rmdir($absFileDir);
                }
            } else { // je soubor smazat ho
                unlink($absFileDir);
            }
        }
    }
    
    public function ajaxChangePositions(HttpRequest $request){
        $response['result'] = 'error';
        if($request->hasParameter('data')){
            $data = $request->getParameter('data');
            foreach($data as $key => $item){
                if($item != null || $item != '')
                    $this->service->updateObjectPosition($key, $item);
            }
            $response['result'] = 'ok';
        }
        $modelAndView = new ModelAndView("admin/raw-data");
        $modelAndView->putParameter("data", json_encode($response));

        return $modelAndView;
    }
    
    /**
     * Vratí pole obrazku které obdrzel v requestu - pouze gallery
     * @param HttpRequest $request
     * @param $class typ tridy obrazku. 
     * @return array
     */
    protected function getArrayOfImages(HttpRequest $request, $class) {
        
        $images = [];

        if( $request->hasParameter($this->imagesPrefix) ) {
            $fileUploadTempDir = $this->getFileUploadTempDir();
            foreach($request->getParameter($this->imagesPrefix) as $index => $value) {
                $image = new $class();
                $imgForm = $this->createImageForm([$this->imagesPrefix, $index]);
                $imgForm->setValues($request->getParameters());
                $imgForm->flush($image);
                
                //otoceni
                if(isset($value["turn"]) && $value["turn"] != 0)
                    $image->setTurn ($value["turn"]);
                
                if( $image->getId() != 0 ) { // je updatovany obrazek
                    $images[] = $image;
                } else { // je nove nahravany obrazek
                    $tempFile = $fileUploadTempDir ."/". $index;
                    if( is_file($tempFile) ) {
                        $image->setImage(new \IZON\IO\Image($tempFile));
                        // TODO: pridat informace o obrazku co se ma vlozit
                        
                        $images[] = $image;
                    }
                }
            }
        }
        
        return $images;
    }
    
    /**
     * Vratí pole obrazku které obdrzel v requestu - pouze gallery
     * @param HttpRequest $request
     * @param $class typ tridy obrazku. 
     * @return array
     */
    protected function getArrayOfFiles(HttpRequest $request, $class){
        
        $files = [];

        if( $request->hasParameter($this->filesPrefix) ) {
            $fileUploadTempDir = $this->getFileUploadTempDir();
            foreach($request->getParameter($this->filesPrefix) as $index => $value) {
                $file = new $class();
                $fileForm = $this->createFileForm([$this->filesPrefix, $index]);
                $fileForm->setValues($request->getParameters());
                $fileForm->flush($file);
                                
                if( $file->getId() != 0 ) { // je updatovany soubor
                    $files[] = $file;
                } else { // je nove nahravany soubor
                    $tempFile = $fileUploadTempDir ."/". $index;
                    if( is_file($tempFile) ) {
                        $file->setFile(new File($tempFile));
                        // TODO: pridat informace o obrazku co se ma vlozit
                        
                        $files[] = $file;
                    }
                }
            }
        }
        
        return $files;
    }
    
    protected function getPhotoFilePath($fileName) {
        return $this->getFileUploadTempDir() . '/' . $fileName;
    }
    
    
    /**
     * Pouziva se pouze pro gallerie
     * @param array $prefix
     * @return Form
     */
    protected function createImageForm(array $prefix) {
        $form = new Form($prefix);
        $form->addIdField("id", __("Id"));
        $form->addIntegerField("position");
        $form->addHiddenField("photoFileName");
        $form->addHiddenField("newPhotoFileName");
        $form->addCharField('description');
        
        return $form;
    }
    
    /**
     * Pouziva se pouze pro soubory
     * @param array $prefix
     * @return Form
     */
    protected function createFileForm(array $prefix){
        $form = new Form($prefix);
        $form->addIdField("id", __("Id"));
        $form->addIntegerField("position");
        $form->addCharField("name");
        $form->addHiddenField("newFileName");
        $form->addHiddenField("fileName");
        $form->addCharField('description');
        $form->addHiddenField('dataType')->setOneWay(true);
        
        return $form;
    }
     
    /**
     * Is posted opeation update?
     * 
     * @param HttpRequest $request
     * @return boolean
     */
    public function _isUpdateOperation(HttpRequest $request) {
      return $request->hasParameter("id") && $request->getParameter("id") + 0 > 0 ? true : false;
    }

    /**
     * Return object
     * 
     * @param HttpRequest $request
     * @return object
     */
    public function _getBaseObject(HttpRequest $request) {
      if($this->_isUpdateOperation($request)) {
        $id     = $request->getParameter("id");
        $object = $this->service->get($id);
      } else {
        $object = $this->createDomainObject();
      }
      return $object;
    }
}
