<?php
namespace IZON\Admin\Services\Impl;

use IZON\Admin\Services\AdminService;

use IZON\DBLocale\Dao\LocaleDao;
use IZON\DBLocale\Dao\CountryDao;
use IZON\DBLocale\Dao\LanguageDao;

use IZON\Admin\Dao\AdminModuleDao;
use IZON\Admin\Dao\AdminModuleSettingDao;

use IZON\DBLocale\Domain\Locale;
use IZON\DBLocale\Domain\Country;
use IZON\DBLocale\Domain\Language;

class AdminServiceImpl implements AdminService {    
    
    /**
     * @var AdminModuleDao 
     */
    protected $adminModuleDao;
    
    /**
     * @var AdminModuleSettingDao 
     */
    protected $adminModuleSettingDao;

    /**
     * @var array 
     */
    protected $supportedInterfaceLocaleIdes;

    /**
     * @var LocaleDao 
     */
    protected $localeDao;
    
    /**
     * @var CountryDao 
     */
    protected $countryDao;
    
    /**
     * @var LanguageDao 
     */
    protected $languageDao;

    
    public function __construct(AdminModuleDao $adminModuleDao,
                                AdminModuleSettingDao $adminModuleSettingDao,
                                LocaleDao $localeDao,
                                CountryDao $countryDao,
                                LanguageDao $languageDao) {
        $this->adminModuleDao         = $adminModuleDao;
        $this->adminModuleSettingDao  = $adminModuleSettingDao;
        $this->localeDao              = $localeDao;
        $this->countryDao             = $countryDao;
        $this->languageDao            = $languageDao;
    }
    
    /**
     * {@inheritdoc}
     */
    function getActiveModules() {
        return $this->adminModuleDao->findActiveModules()->listResult();
    }
    
    function getLoggedUserModules() {
        return [];
    }

    /**
     * {@inheritdoc}
     */
    public function getModuleSetting($moduleIdentifier, $parameterIdentifier) {
        /* @var $module \IZON\Admin\Domain\AdminModule */
        $module = $this->adminModuleDao->find(["identifier" => $moduleIdentifier])->uniqueResult();
        /* @var $moduleSettings \IZON\Admin\Domain\AdminModuleSetting */
        $moduleSettings =  $this->adminModuleSettingDao->find(["fkAdminModuleId" => $module->getId(), "paramIdentifier" => $parameterIdentifier])->uniqueResult();
        return $moduleSettings;
    }

    /**
     * {@inheritdoc}
     */
    public function getModuleSettings($moduleIdentifier) {
        /* @var $module \IZON\Admin\Domain\AdminModule */
        $module = $this->adminModuleDao->find(["identifier" => $moduleIdentifier])->uniqueResult();
        return $this->adminModuleSettingDao->find(["fkAdminModuleId" => $module->getId()])->listResult();
    }
    
    /**
     * {@inheritdoc}
     */
    public function getSupportedCountries() {
        return $this->countryDao->find(['enabled' => 1])->listResult();
    }
    
    /**
     * {@inheritdoc}
     */
    public function getSupportedInterfaceLocales() {
        $supportedInterfaceLocales = [];
        foreach($this->supportedInterfaceLocaleIdes as $supportedInterfaceLocaleId) {
            /* @var $locale Locale */
            $locale = $this->localeDao->load($supportedInterfaceLocaleId);
            /* @var $country Country */
            $country = $this->countryDao->load($locale->getFkCountryId());
            $locale->setCountry($country);
            /* @var $language Language */
            $language = $this->languageDao->load($locale->getFkLanguageId());
            $locale->setLanguage($language);
            $supportedInterfaceLocales[] = $locale;
        }
        return $supportedInterfaceLocales;
    }
    
    /**
     * {@inheritdoc}
     */
    public function getAdminVersion() {
        $version = json_decode(file_get_contents(__DIR__ .'/../../../../../composer.json'), true)['version'];
        return $version;
    }
    
    /**
     * {@inheritdoc}
     */
    function setSupportedInterfaceLocaleIdes(array $supportedInterfaceLocaleIdes = [1]) {
        $this->supportedInterfaceLocaleIdes = $supportedInterfaceLocaleIdes;
    }
}