<?php

namespace IZON\Admin\MVC\Views;

use Exception;

use IZON\Logs\Logger;

/**
 * trida renderujici view, resici cachovani rendrovani view, skladajici view 
 * z jednotlivych casti, ...
 * jednotliva view jsou ulozena v adresarich
 * pri devel modu naincluduje nekde dole ve strance misto na debug informace
 *
 * @author David Dryml <dryml@izon.cz>
 * @copyright Copyright 2009, HI Software s.r.o.
 *
 * @version v1.0 rc
 *
 * @package MVC
 */
class AdminPHPLayoutView extends AdminPHPView {

    /**
     * suffix of template part file
     */
    const PART_SUFFIX = ".tmpl.php";
    
    /**
     * suffix of layout file
     */
    const LAYOUT_SUFFIX = ".lay.php";

    /**
     * cesty k adresari s views pro jednotlive moduly 
     * @var array 
     */
    protected $layoutPartsDirs;
    
    /**
     * logger pro tridu
     * @var Logger 
     */
    protected $log;
    
    /**
     * vytvari view podle zadaneho jmena a predava mu parametry
     */
    function __construct($layoutFilePath, array $layoutPartsDirs) {
        parent::__construct($layoutFilePath);
        
        $this->layoutPartsDirs = $layoutPartsDirs;
         // logovani
        $this->log = Logger::getLogger(__CLASS__);
    }
    
    /**
     * provede renderovani soucasti graficleho rozhrani
     */
    function renderLayoutPart($partName) {
        $partFilePath = $this->findLayoutPartFilePath($partName);
        require $partFilePath;
    }

    /**
     * najde cestu k potrebne casti grafickeho rozhrani
     */
    protected function findLayoutPartFilePath($partName) {
        $this->log->info("Calling findLayoutPartFilePath with parameter: [$partName]");
        
        $localeTag = $this->getLocale()->toLocaleTag();
        foreach($this->layoutPartsDirs as $layoutPartDir) {
            $templatePartFilePath =  $layoutPartDir ."/". $partName .".". $localeTag . self::PART_SUFFIX;
            if( file_exists($templatePartFilePath) 
                && is_file($templatePartFilePath) ) {
                $this->log->info("Found template $templatePartFilePath");
                return $templatePartFilePath;
            }
            
            $templatePartFilePath =  $layoutPartDir ."/". $partName . self::PART_SUFFIX;
            if( file_exists($templatePartFilePath) 
                && is_file($templatePartFilePath) ) {
                $this->log->info("Found template $templatePartFilePath");
                return $templatePartFilePath;
            }
        }
        
        throw new Exception("Layout part ". $partName ." not found");
        
        
        // search all modules tempalte parhs for parts 
//        foreach($this->modulesPaths as $modulePath => $shordedViewName) {
//            $templatePartFolder = $modulePath ."/". $shordedViewName;
//            
//            // try language specific file
//            $templatePartFile =  $templatePartFolder ."/". $partName .".". $this->getLang() . self::PART_SUFFIX;
//            $this->log->info("Trying template $templatePartFile");
//            if( file_exists($templatePartFile) 
//                && is_file($templatePartFile) ) {
//                $this->log->info("Found template $templatePartFile");
//                return $templatePartFile;
//            }
//            
//            // try language nonspecific file
//            $templatePartFile =  $templatePartFolder ."/". $partName . self::PART_SUFFIX;
//            $this->log->info("Trying template $templatePartFile");
//            if( file_exists($templatePartFile) 
//                && is_file($templatePartFile) ) {
//                $this->log->info("Found template $templatePartFile");
//                return $templatePartFile;
//            }
//            
//            // zkusit projit stromem ke koreni
//            $dirsArray = explode("/", $shordedViewName);
//            for($i = count($dirsArray) - 1; $i >= 0; $i--) {
//                $dir = $this->createSubdir($dirsArray, $i);
//                
//                // pokusit se najit part primo ve specific view pro danou aplikaci/web
//                $templatePartFile = $this->specificViewsDir ."/". $dir ."/". $partName . self::PART_SUFFIX;
//                if( file_exists($templatePartFile) 
//                    && is_file($templatePartFile) ) {
//                    $this->log->info("Found template $templatePartFile");
//                    return $templatePartFile;
//                }
//                
//                
//                $templatePartFile =  $modulePath ."/". $dir ."/". $partName .".". $this->getLang() . self::PART_SUFFIX;
//                $this->log->info("Trying template $templatePartFile");
//                if( file_exists($templatePartFile) 
//                    && is_file($templatePartFile) ) {
//                    $this->log->info("Found template $templatePartFile");
//                    return $templatePartFile;
//                }
//
//                // try language nonspecific file
//                $templatePartFile =  $modulePath ."/". $dir ."/". $partName . self::PART_SUFFIX;
//                if( file_exists($templatePartFile) 
//                    && is_file($templatePartFile) ) {
//                    $this->log->info("Found template $templatePartFile");
//                    return $templatePartFile;
//                }
//            }
//        }
        
//        throw new Exception("mrtva vetev");
    }
}